/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.security;

import cn.ibizlab.util.security.AuthenticationUser;
import org.springframework.util.Assert;

final class AuthenticationContextHolder {
    private static final ThreadLocal<AuthenticationUser> contextHolder = new ThreadLocal();

    AuthenticationContextHolder() {
    }

    public static void clearContext() {
        contextHolder.remove();
    }

    public static AuthenticationUser getContext() {
        AuthenticationUser ctx = contextHolder.get();
        return ctx;
    }

    public static void setContext(AuthenticationUser context) {
        Assert.notNull((Object)context, (String)"Only non-null AuthenticationUser instances are permitted");
        contextHolder.set(context);
    }
}

