/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.security;

import cn.ibizlab.util.security.AuthMember;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@JsonIgnoreProperties(value={"handler"})
@ApiModel(value="AUTH_USER", description="\u8ba4\u8bc1\u7528\u6237for UAA2.0")
public class AuthUser20Impl
implements AuthenticationUser {
    private static final Logger log = LoggerFactory.getLogger(AuthUser20Impl.class);
    @Id
    @JsonProperty(value="id")
    @JSONField(name="id")
    @ApiModelProperty(value="id", notes="\u6807\u8bc6")
    private String id;
    @JsonProperty(value="display_name")
    @JSONField(name="display_name")
    @ApiModelProperty(value="display_name", notes="\u540d\u79f0")
    private String displayName;
    @JsonProperty(value="username")
    @JSONField(name="username")
    @ApiModelProperty(value="username", notes="username/uid")
    private String username;
    @JsonProperty(value="dc")
    @JSONField(name="dc")
    @ApiModelProperty(value="dc", notes="DC")
    private String dc;
    @JsonProperty(value="organization_id")
    @JSONField(name="organization_id")
    @ApiModelProperty(value="organization_id", notes="\u7ec4\u7ec7\u673a\u6784\u6807\u8bc6")
    private String organizationId;
    @JsonProperty(value="organization_number")
    @JSONField(name="organization_number")
    @ApiModelProperty(value="organization_number", notes="\u673a\u6784\u7f16\u53f7")
    private String organizationNumber;
    @JsonProperty(value="organization_name")
    @JSONField(name="organization_name")
    @ApiModelProperty(value="organization_name", notes="\u7ec4\u7ec7\u673a\u6784\u540d\u79f0")
    private String organizationName;
    @JsonProperty(value="department_id")
    @JSONField(name="department_id")
    @ApiModelProperty(value="department_id", notes="\u90e8\u95e8\u6807\u8bc6")
    private String departmentId;
    @JsonProperty(value="department_number")
    @JSONField(name="department_number")
    @ApiModelProperty(value="department_number", notes="\u90e8\u95e8\u7f16\u53f7")
    private String departmentNumber;
    @JsonProperty(value="department_name")
    @JSONField(name="department_name")
    @ApiModelProperty(value="department_name", notes="\u90e8\u95e8\u540d\u79f0")
    private String departmentName;
    @JsonProperty(value="organizational_role_id")
    @JSONField(name="organizational_role_id")
    @ApiModelProperty(value="organizational_role_id", notes="\u7528\u6237\u7ec4\u6807\u8bc6")
    private String organizationalRoleId;
    @JsonProperty(value="organizational_role_name")
    @JSONField(name="organizational_role_name")
    @ApiModelProperty(value="organizational_role_name", notes="\u7528\u6237\u7ec4\u540d\u79f0")
    private String organizationalRoleName;
    @JsonProperty(value="deploy_system_id")
    @JSONField(name="deploy_system_id")
    @ApiModelProperty(value="deploy_system_id", notes="\u7cfb\u7edf\u6807\u8bc6")
    private String deploySystemId;
    @JsonProperty(value="system_id")
    @JSONField(name="system_id")
    @ApiModelProperty(value="system_id", notes="\u7cfb\u7edf\u540d")
    private String systemId;
    @JsonProperty(value="employee_number")
    @JSONField(name="employee_number")
    @ApiModelProperty(value="employee_number", notes="\u4eba\u5458\u7f16\u53f7")
    private String employeeNumber;
    @JsonProperty(value="employee_type")
    @JSONField(name="employee_type")
    @ApiModelProperty(value="employee_type", notes="\u7c7b\u578b")
    private String employeeType;
    @JsonProperty(value="title")
    @JSONField(name="title")
    @ApiModelProperty(value="title", notes="\u804c\u4f4d")
    private String title;
    @JsonProperty(value="mail")
    @JSONField(name="mail")
    @ApiModelProperty(value="mail", notes="\u7535\u5b50\u90ae\u7bb1")
    private String mail;
    @JsonProperty(value="telephone_number")
    @JSONField(name="telephone_number")
    @ApiModelProperty(value="telephone_number", notes="\u8054\u7cfb\u7535\u8bdd")
    private String telephoneNumber;
    @JsonProperty(value="mobile")
    @JSONField(name="mobile")
    @ApiModelProperty(value="mobile", notes="\u79fb\u52a8\u7535\u8bdd")
    private String mobile;
    @JsonProperty(value="identification_number")
    @JSONField(name="identification_number")
    @ApiModelProperty(value="identification_number", notes="\u8bc1\u4ef6\u53f7")
    private String identificationNumber;
    @JsonProperty(value="postal_address")
    @JSONField(name="postal_address")
    @ApiModelProperty(value="postal_address", notes="\u5730\u5740")
    private String postalAddress;
    @JsonProperty(value="description")
    @JSONField(name="description")
    @ApiModelProperty(value="description", notes="\u63cf\u8ff0")
    private String description;
    @JsonProperty(value="super_user")
    @JSONField(name="super_user")
    @ApiModelProperty(value="super_user", notes="\u8d85\u7ea7\u7ba1\u7406\u5458")
    private Integer superUser;
    @JsonProperty(value="api_user")
    @JSONField(name="api_user")
    @ApiModelProperty(value="api_user", notes="API\u7528\u6237")
    private Integer api_user;
    @JsonProperty(value="device_info")
    @JSONField(name="device_info")
    @ApiModelProperty(value="device_info", notes="User-Agent")
    private String deviceInfo;
    @JsonProperty(value="client_ip")
    @JSONField(name="client_ip")
    @ApiModelProperty(value="client_ip", notes="\u5ba2\u6237\u7aefip")
    private String clientIp;
    @JsonProperty(value="avatar")
    @JSONField(name="avatar")
    @ApiModelProperty(value="avatar", notes="\u5934\u50cf")
    private String avatar;
    @JsonProperty(value="cur_member_of")
    @JSONField(name="cur_member_of")
    @ApiModelProperty(value="cur_member_of", notes="\u5f53\u524d\u96b6\u5c5e\u4e8e")
    private AuthMember curMemberOf;
    @JsonProperty(value="member_of")
    @JSONField(name="member_of")
    @ApiModelProperty(value="member_of", notes="\u96b6\u5c5e\u4e8e")
    private List<AuthMember> memberOf;
    @JsonProperty(value="roles")
    @JSONField(name="roles")
    @ApiModelProperty(value="roles", notes="\u7cfb\u7edf\u6388\u6743")
    private List<AuthGrantedSystem> roles;
    @JsonIgnore
    @JSONField(serialize=false)
    private String password;
    @JsonIgnore
    @JSONField(serialize=false)
    private LinkedHashSet<GrantedAuthority> authorities;
    private Set<String> parentOrgIds = new LinkedHashSet<String>();
    private Set<String> subOrgIds = new LinkedHashSet<String>();
    private Set<String> parentDeptIds = new LinkedHashSet<String>();
    private Set<String> subDeptIds = new LinkedHashSet<String>();
    private static final String SRF_ORG_ID = "srforgid";
    private static final String SRF_ORG_SECTOR_ID = "srforgsectorid";
    private static final String SRF_DC_SYSTEM_ID = "srfdcsystemid";
    private static final String SRF_SYSTEM_ID = "srfsystemid";
    private static final String UNDEFINED = "undefined";
    @JsonIgnore
    @JSONField(serialize=false)
    @Transient
    private Map<String, Object> extensionparams;
    @JsonIgnore
    @JSONField(serialize=false)
    private Map<String, Object> sessionParams;

    @Override
    @JsonIgnore
    @JSONField(serialize=false)
    public boolean isSuperUser() {
        return Integer.valueOf(1).equals(this.superUser);
    }

    @Override
    @JsonIgnore
    @JSONField(serialize=false)
    public boolean isApiUser() {
        return Integer.valueOf(1).equals(this.api_user);
    }

    @JsonIgnore
    @JSONField(serialize=false)
    public LinkedHashSet<GrantedAuthority> getAuthorities() {
        if (this.authorities == null && !ObjectUtils.isEmpty(this.getRoles())) {
            this.authorities = new LinkedHashSet();
            this.getRoles().forEach(system -> {
                this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(String.format("SYSTEM_%1$s", system.getDeploySystemId())));
                if (!ObjectUtils.isEmpty((Object)system.getSystemId())) {
                    this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(String.format("SYSTEM_%1$s", system.getSystemId())));
                }
                if (ObjectUtils.isEmpty(system.getRoles())) {
                    return;
                }
                system.getRoles().forEach(role -> {
                    if (ObjectUtils.isEmpty((Object)role.getAuthority())) {
                        return;
                    }
                    if (role.getAuthority().equalsIgnoreCase("ROLE_SUPERADMIN") || role.getAuthority().equalsIgnoreCase("ROLE_APIUSERS")) {
                        this.setSuperUser(1);
                    }
                    if (role.getAuthority().equalsIgnoreCase("ROLE_APIUSERS")) {
                        this.setApiUser(1);
                    }
                    this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(String.format("ROLE_%1$s", role.getRoleId())));
                    this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role.getAuthority()));
                    if (!ObjectUtils.isEmpty((Object)system.getSystemId())) {
                        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(String.format("ROLE_%1$s_%2$s", system.getSystemId(), role.getAuthority())));
                    }
                    if (!ObjectUtils.isEmpty(role.getAuthorities())) {
                        role.getAuthorities().forEach(authGranted -> {
                            String authority = authGranted.getAuthority();
                            if (!ObjectUtils.isEmpty((Object)authority) && authority.indexOf(":") > 0) {
                                authority = authority.split(":")[1];
                            }
                            if (!ObjectUtils.isEmpty((Object)authority)) {
                                CharSequence[] args = authority.split("-");
                                if ("OPPRIV".equals(authGranted.getPermissionType()) && args.length == 4 && args[2].startsWith("Fetch")) {
                                    this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(authority));
                                    args[2] = args[2].replace("Fetch", "search");
                                    authority = String.join((CharSequence)"-", args);
                                }
                                if ("APPMENU".equals(authGranted.getPermissionType()) && args.length == 4) {
                                    this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(authority));
                                    authority = String.join((CharSequence)"-", args[0], "APPMENU", args[1], args[2], args[3]);
                                }
                                this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(authority));
                            }
                        });
                    }
                });
            });
        }
        return this.authorities;
    }

    @Override
    public void setMemberOf(List<AuthMember> memberOf) {
        this.memberOf = memberOf;
        if (!ObjectUtils.isEmpty(memberOf)) {
            this.changeOU(this.getOrganizationId(), this.getDepartmentId(), this.getOrganizationalRoleId());
        }
    }

    @Override
    public void setCurMemberOf(AuthMember curMemberOf) {
        this.curMemberOf = curMemberOf;
        if (curMemberOf != null) {
            this.setOrganizationId(curMemberOf.getOrganizationId());
            this.setOrganizationNumber(curMemberOf.getOrganizationNumber());
            this.setOrganizationName(curMemberOf.getOrganizationName());
            this.setDepartmentId(curMemberOf.getDepartmentId());
            this.setDepartmentNumber(curMemberOf.getDepartmentNumber());
            this.setDepartmentName(curMemberOf.getDepartmentName());
            this.setOrganizationalRoleId(curMemberOf.getOrganizationalRoleId());
            this.setOrganizationalRoleName(curMemberOf.getOrganizationalRoleName());
            if (!ObjectUtils.isEmpty((Object)curMemberOf.getDc())) {
                this.setDc(curMemberOf.getDc());
            }
        }
    }

    public AuthUser20Impl changeOU(String organizationId, String departmentId, String organizationalRoleId) {
        if (!ObjectUtils.isEmpty(this.getMemberOf())) {
            AuthMember member = this.getMemberOfByOrganizationalRoleId(organizationalRoleId);
            if (member == null && (member = this.getMemberOfByDepartmentId(departmentId)) == null) {
                member = this.getMemberOfByOrganizationId(organizationId);
            }
            if (member != null) {
                this.setCurMemberOf(member);
            } else {
                this.setCurMemberOf(this.getMemberOf().get(0));
                log.warn("{}\u5207\u6362OU\u5931\u8d25:o={},ou={},cn={}\u672a\u627e\u5230memberOf.", new Object[]{this.getUsername(), organizationId, departmentId, organizationalRoleId});
            }
            this.sessionParams = null;
        }
        return this;
    }

    public AuthMember getMemberOfByOrganizationId(String organizationId) {
        Optional<AuthMember> member;
        if (!ObjectUtils.isEmpty(this.getMemberOf()) && !ObjectUtils.isEmpty((Object)organizationId) && (member = this.getMemberOf().stream().filter(item -> organizationId.equals(item.getOrganizationId())).findFirst()).isPresent()) {
            return member.get();
        }
        return null;
    }

    public AuthMember getMemberOfByDepartmentId(String departmentId) {
        Optional<AuthMember> member;
        if (!ObjectUtils.isEmpty(this.getMemberOf()) && !ObjectUtils.isEmpty((Object)departmentId) && (member = this.getMemberOf().stream().filter(item -> departmentId.equals(item.getDepartmentId())).findFirst()).isPresent()) {
            return member.get();
        }
        return null;
    }

    public AuthMember getMemberOfByOrganizationalRoleId(String organizationalRoleId) {
        Optional<AuthMember> member;
        if (!ObjectUtils.isEmpty(this.getMemberOf()) && !ObjectUtils.isEmpty((Object)organizationalRoleId) && (member = this.getMemberOf().stream().filter(item -> organizationalRoleId.equals(item.getOrganizationalRoleId())).findFirst()).isPresent()) {
            return member.get();
        }
        return null;
    }

    public void setRoles(List<AuthGrantedSystem> roles) {
        this.roles = roles;
        this.changeSystem(this.getDeploySystemId(), this.getSystemId());
    }

    public AuthUser20Impl changeSystem(String deploySystemId, String systemId) {
        if (!ObjectUtils.isEmpty(this.getRoles())) {
            AuthGrantedSystem system = this.getSystemByDeploySystemId(deploySystemId);
            if (system == null) {
                system = this.getSystemBySystemId(systemId);
            }
            if (system == null) {
                system = this.getRoles().get(0);
            }
            this.setDeploySystemId(system.getDeploySystemId());
            this.setSystemId(system.getSystemId());
            this.sessionParams = null;
        }
        return this;
    }

    public AuthGrantedSystem getSystemByDeploySystemId(String deploySystemId) {
        Optional<AuthGrantedSystem> system;
        if (!ObjectUtils.isEmpty(this.getRoles()) && !ObjectUtils.isEmpty((Object)deploySystemId) && (system = this.getRoles().stream().filter(item -> deploySystemId.equals(item.getDeploySystemId())).findFirst()).isPresent()) {
            return system.get();
        }
        return null;
    }

    public AuthGrantedSystem getSystemBySystemId(String systemId) {
        Optional<AuthGrantedSystem> system;
        if (!ObjectUtils.isEmpty(this.getRoles()) && !ObjectUtils.isEmpty((Object)systemId) && (system = this.getRoles().stream().filter(item -> systemId.equals(item.getSystemId())).findFirst()).isPresent()) {
            return system.get();
        }
        return null;
    }

    @Override
    public void readHeader(boolean change) {
        HttpServletRequest request;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && (request = requestAttributes.getRequest()) != null) {
            String srfsystemid;
            String srfdcsystemid;
            String srforgsectorid;
            String srforgid;
            Enumeration headerNames;
            if (change && (headerNames = request.getHeaderNames()) != null) {
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    if (!name.startsWith("srf")) continue;
                    this.getExtensionparams().put(name, request.getHeader(name));
                }
            }
            if (UNDEFINED.equals(srforgid = request.getHeader(SRF_ORG_ID))) {
                srforgid = null;
            }
            if (UNDEFINED.equals(srforgsectorid = request.getHeader(SRF_ORG_SECTOR_ID))) {
                srforgsectorid = null;
            }
            if (UNDEFINED.equals(srfdcsystemid = request.getHeader(SRF_DC_SYSTEM_ID))) {
                srfdcsystemid = null;
            }
            if (UNDEFINED.equals(srfsystemid = request.getHeader(SRF_SYSTEM_ID))) {
                srfsystemid = null;
            }
            if (!ObjectUtils.isEmpty((Object)srforgid) && !srforgid.equals(this.getOrganizationId()) || !ObjectUtils.isEmpty((Object)srforgsectorid) && !srforgsectorid.equals(this.getDepartmentId())) {
                this.changeOU(srforgid, srforgsectorid, null);
            }
            if (!ObjectUtils.isEmpty((Object)srfdcsystemid) && !srfdcsystemid.equals(this.getDeploySystemId()) || !ObjectUtils.isEmpty((Object)srfsystemid) && !srfsystemid.equals(this.getSystemId())) {
                this.changeSystem(srfdcsystemid, srfsystemid);
            }
        }
    }

    @Override
    @JsonIgnore
    @JSONField(serialize=false)
    public Map<String, Object> getExtensionparams() {
        if (this.extensionparams == null) {
            this.extensionparams = new HashMap<String, Object>();
        }
        return this.extensionparams;
    }

    @Override
    @JsonIgnore
    @JSONField(serialize=false)
    public Map getSessionParams() {
        if (this.sessionParams == null) {
            this.sessionParams = new LinkedHashMap<String, Object>();
            this.sessionParams.putAll(this.getExtensionparams());
            this.sessionParams.put("id", this.getId());
            this.sessionParams.put("username", this.getUsername());
            this.sessionParams.put("display_name", this.getDisplayName());
            this.sessionParams.put("dc", this.getDc());
            this.sessionParams.put("employee_number", this.getEmployeeNumber());
            this.sessionParams.put("employee_type", this.getEmployeeType());
            this.sessionParams.put("title", this.getTitle());
            this.sessionParams.put("mail", this.getMail());
            this.sessionParams.put("telephone_number", this.getTelephoneNumber());
            this.sessionParams.put("mobile", this.getMobile());
            this.sessionParams.put("identification_number", this.getIdentificationNumber());
            this.sessionParams.put("postal_address", this.getPostalAddress());
            this.sessionParams.put("userid", this.getId());
            this.sessionParams.put("srfpersonid", this.getId());
            this.sessionParams.put("srfpersonname", this.getDisplayName());
            this.sessionParams.put("srfuserid", this.getId());
            this.sessionParams.put("srfusercode", this.getEmployeeNumber());
            this.sessionParams.put("srfusername", this.getDisplayName());
            if (this.getCurMemberOf() != null) {
                this.sessionParams.put("organization_id", this.getCurMemberOf().getOrganizationId());
                this.sessionParams.put("organization_number", this.getCurMemberOf().getOrganizationNumber());
                this.sessionParams.put("organization_name", this.getCurMemberOf().getOrganizationName());
                this.sessionParams.put("department_id", this.getCurMemberOf().getDepartmentId());
                this.sessionParams.put("department_number", this.getCurMemberOf().getDepartmentNumber());
                this.sessionParams.put("department_name", this.getCurMemberOf().getDepartmentName());
                this.sessionParams.put("organizational_role_id", this.getCurMemberOf().getOrganizationalRoleId());
                this.sessionParams.put("organizational_role_name", this.getCurMemberOf().getOrganizationalRoleName());
                this.sessionParams.put(SRF_ORG_ID, this.getCurMemberOf().getOrganizationId());
                this.sessionParams.put("srforgcode", this.getCurMemberOf().getOrganizationNumber());
                this.sessionParams.put("srforgname", this.getCurMemberOf().getOrganizationName());
                this.sessionParams.put(SRF_ORG_SECTOR_ID, this.getCurMemberOf().getDepartmentId());
                this.sessionParams.put("srforgsectorcode", this.getCurMemberOf().getDepartmentNumber());
                this.sessionParams.put("srforgsectorname", this.getCurMemberOf().getDepartmentName());
                this.sessionParams.put("srfteamid", this.getCurMemberOf().getOrganizationalRoleId());
            } else {
                this.sessionParams.put("organization_id", this.getOrganizationId());
                this.sessionParams.put("organization_number", this.getOrganizationNumber());
                this.sessionParams.put("organization_name", this.getOrganizationName());
                this.sessionParams.put("department_id", this.getDepartmentId());
                this.sessionParams.put("department_number", this.getDepartmentNumber());
                this.sessionParams.put("department_name", this.getDepartmentName());
                this.sessionParams.put("organizational_role_id", this.getOrganizationalRoleId());
                this.sessionParams.put("organizational_role_name", this.getOrganizationalRoleName());
                this.sessionParams.put(SRF_ORG_ID, this.getOrganizationId());
                this.sessionParams.put("srforgcode", this.getOrganizationNumber());
                this.sessionParams.put("srforgname", this.getOrganizationName());
                this.sessionParams.put(SRF_ORG_SECTOR_ID, this.getDepartmentId());
                this.sessionParams.put("srforgsectorcode", this.getDepartmentNumber());
                this.sessionParams.put("srforgsectorname", this.getDepartmentName());
                this.sessionParams.put("srfteamid", this.getOrganizationalRoleId());
            }
            this.sessionParams.put("srfloginname", this.getUsername());
            this.sessionParams.put("srftimezone", "");
            this.sessionParams.put("srfcorg", this.getCond(this.getCurOrgIds()));
            this.sessionParams.put("srfcdept", this.getCond(this.getCurDeptIds()));
            this.sessionParams.put("srfcteam", this.getCond(this.getCurTeamIds()));
            this.sessionParams.put("srfporg", this.getCond(this.getParentOrgIds()));
            this.sessionParams.put("srfsorg", this.getCond(this.getSubOrgIds()));
            this.sessionParams.put("srfpdept", this.getCond(this.getParentDeptIds()));
            this.sessionParams.put("srfsdept", this.getCond(this.getSubDeptIds()));
            if (this.sessionParams.get("srfdcid") == null && this.getDc() != null) {
                this.sessionParams.put("srfdcid", this.getDc());
            }
            if (this.sessionParams.get(SRF_DC_SYSTEM_ID) == null && this.getDeploySystemId() != null) {
                this.sessionParams.put(SRF_DC_SYSTEM_ID, this.getDeploySystemId());
            }
            if (this.sessionParams.get(SRF_SYSTEM_ID) == null && this.getSystemId() != null) {
                this.sessionParams.put(SRF_SYSTEM_ID, this.getSystemId());
            }
            this.sessionParams.put("member_of", this.getMemberOf());
            this.sessionParams.put("roles", this.getRoles());
        }
        return this.sessionParams;
    }

    private String getCond(Collection items) {
        return ObjectUtils.isEmpty((Object)items) ? null : "'" + String.join((CharSequence)"','", items) + "'";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getDc() {
        return this.dc;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public String getOrganizationNumber() {
        return this.organizationNumber;
    }

    @Override
    public String getOrganizationName() {
        return this.organizationName;
    }

    @Override
    public String getDepartmentId() {
        return this.departmentId;
    }

    @Override
    public String getDepartmentNumber() {
        return this.departmentNumber;
    }

    @Override
    public String getDepartmentName() {
        return this.departmentName;
    }

    @Override
    public String getOrganizationalRoleId() {
        return this.organizationalRoleId;
    }

    @Override
    public String getOrganizationalRoleName() {
        return this.organizationalRoleName;
    }

    @Override
    public String getDeploySystemId() {
        return this.deploySystemId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    @Override
    public String getEmployeeType() {
        return this.employeeType;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getMail() {
        return this.mail;
    }

    @Override
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @Override
    public String getMobile() {
        return this.mobile;
    }

    @Override
    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    @Override
    public String getPostalAddress() {
        return this.postalAddress;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Integer getSuperUser() {
        return this.superUser;
    }

    public Integer getApi_user() {
        return this.api_user;
    }

    @Override
    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    @Override
    public String getClientIp() {
        return this.clientIp;
    }

    public String getAvatar() {
        return this.avatar;
    }

    @Override
    public AuthMember getCurMemberOf() {
        return this.curMemberOf;
    }

    @Override
    public List<AuthMember> getMemberOf() {
        return this.memberOf;
    }

    public List<AuthGrantedSystem> getRoles() {
        return this.roles;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Set<String> getParentOrgIds() {
        return this.parentOrgIds;
    }

    @Override
    public Set<String> getSubOrgIds() {
        return this.subOrgIds;
    }

    @Override
    public Set<String> getParentDeptIds() {
        return this.parentDeptIds;
    }

    @Override
    public Set<String> getSubDeptIds() {
        return this.subDeptIds;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @Override
    @JsonProperty(value="display_name")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    @JsonProperty(value="dc")
    public void setDc(String dc) {
        this.dc = dc;
    }

    @Override
    @JsonProperty(value="organization_id")
    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    @Override
    @JsonProperty(value="organization_number")
    public void setOrganizationNumber(String organizationNumber) {
        this.organizationNumber = organizationNumber;
    }

    @Override
    @JsonProperty(value="organization_name")
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    @Override
    @JsonProperty(value="department_id")
    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    @Override
    @JsonProperty(value="department_number")
    public void setDepartmentNumber(String departmentNumber) {
        this.departmentNumber = departmentNumber;
    }

    @Override
    @JsonProperty(value="department_name")
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @Override
    @JsonProperty(value="organizational_role_id")
    public void setOrganizationalRoleId(String organizationalRoleId) {
        this.organizationalRoleId = organizationalRoleId;
    }

    @Override
    @JsonProperty(value="organizational_role_name")
    public void setOrganizationalRoleName(String organizationalRoleName) {
        this.organizationalRoleName = organizationalRoleName;
    }

    @Override
    @JsonProperty(value="deploy_system_id")
    public void setDeploySystemId(String deploySystemId) {
        this.deploySystemId = deploySystemId;
    }

    @Override
    @JsonProperty(value="system_id")
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    @JsonProperty(value="employee_number")
    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    @Override
    @JsonProperty(value="employee_type")
    public void setEmployeeType(String employeeType) {
        this.employeeType = employeeType;
    }

    @Override
    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @JsonProperty(value="mail")
    public void setMail(String mail) {
        this.mail = mail;
    }

    @Override
    @JsonProperty(value="telephone_number")
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    @Override
    @JsonProperty(value="mobile")
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Override
    @JsonProperty(value="identification_number")
    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    @Override
    @JsonProperty(value="postal_address")
    public void setPostalAddress(String postalAddress) {
        this.postalAddress = postalAddress;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @JsonProperty(value="super_user")
    public void setSuperUser(Integer superUser) {
        this.superUser = superUser;
    }

    @JsonProperty(value="api_user")
    public void setApi_user(Integer api_user) {
        this.api_user = api_user;
    }

    @Override
    @JsonProperty(value="device_info")
    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    @Override
    @JsonProperty(value="client_ip")
    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    @JsonProperty(value="avatar")
    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    @Override
    @JsonIgnore
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonIgnore
    public void setAuthorities(LinkedHashSet<GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public void setParentOrgIds(Set<String> parentOrgIds) {
        this.parentOrgIds = parentOrgIds;
    }

    public void setSubOrgIds(Set<String> subOrgIds) {
        this.subOrgIds = subOrgIds;
    }

    public void setParentDeptIds(Set<String> parentDeptIds) {
        this.parentDeptIds = parentDeptIds;
    }

    public void setSubDeptIds(Set<String> subDeptIds) {
        this.subDeptIds = subDeptIds;
    }

    @JsonIgnore
    public void setExtensionparams(Map<String, Object> extensionparams) {
        this.extensionparams = extensionparams;
    }

    @JsonIgnore
    public void setSessionParams(Map<String, Object> sessionParams) {
        this.sessionParams = sessionParams;
    }

    @JsonIgnoreProperties(value={"handler"})
    @ApiModel(value="AUTH_GRANTED", description="\u6388\u6743\u5bf9\u8c61")
    public static class AuthGranted
    implements Serializable {
        @Id
        @JsonProperty(value="authority")
        @JSONField(name="authority")
        @ApiModelProperty(value="authority", notes="\u8d44\u6e90\u7b26")
        private String authority;
        @JsonProperty(value="permission_type")
        @JSONField(name="permission_type")
        @ApiModelProperty(value="permission_type", notes="\u6743\u9650\u7c7b\u578b")
        private String permissionType;
        @JsonProperty(value="display_name")
        @JSONField(name="display_name")
        @ApiModelProperty(value="display_name", notes="\u663e\u793a\u540d")
        private String displayName;

        public String getAuthority() {
            return this.authority;
        }

        public String getPermissionType() {
            return this.permissionType;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        @JsonProperty(value="authority")
        public AuthGranted setAuthority(String authority) {
            this.authority = authority;
            return this;
        }

        @JsonProperty(value="permission_type")
        public AuthGranted setPermissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @JsonProperty(value="display_name")
        public AuthGranted setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }
    }

    @JsonIgnoreProperties(value={"handler"})
    @ApiModel(value="AUTH_GRANTED_ROLE", description="\u6388\u6743\u89d2\u8272")
    public static class AuthGrantedRole
    implements Serializable {
        @Id
        @JsonProperty(value="role_id")
        @JSONField(name="role_id")
        @ApiModelProperty(value="role_id", notes="\u89d2\u8272\u6807\u8bc6")
        private String roleId;
        @JsonProperty(value="display_name")
        @JSONField(name="display_name")
        @ApiModelProperty(value="display_name", notes="\u89d2\u8272\u540d")
        private String displayName;
        @JsonProperty(value="authority")
        @JSONField(name="authority")
        @ApiModelProperty(value="authority", notes="\u89d2\u8272\u4ee3\u7801\u6807\u8bb0")
        private String authority;
        @JsonProperty(value="authorities")
        @JSONField(name="authorities")
        @ApiModelProperty(value="authorities", notes="\u6388\u6743\u6e05\u5355")
        private List<AuthGranted> authorities;

        public String getRoleId() {
            return this.roleId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getAuthority() {
            return this.authority;
        }

        public List<AuthGranted> getAuthorities() {
            return this.authorities;
        }

        @JsonProperty(value="role_id")
        public AuthGrantedRole setRoleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        @JsonProperty(value="display_name")
        public AuthGrantedRole setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @JsonProperty(value="authority")
        public AuthGrantedRole setAuthority(String authority) {
            this.authority = authority;
            return this;
        }

        @JsonProperty(value="authorities")
        public AuthGrantedRole setAuthorities(List<AuthGranted> authorities) {
            this.authorities = authorities;
            return this;
        }
    }

    @JsonIgnoreProperties(value={"handler"})
    @ApiModel(value="AUTH_GRANTED_SYSTEM", description="\u6388\u6743\u7cfb\u7edf")
    public static class AuthGrantedSystem
    implements Serializable {
        @Id
        @JsonProperty(value="deploy_system_id")
        @JSONField(name="deploy_system_id")
        @ApiModelProperty(value="deploy_system_id", notes="\u7cfb\u7edf\u6807\u8bc6")
        private String deploySystemId;
        @JsonProperty(value="display_name")
        @JSONField(name="display_name")
        @ApiModelProperty(value="display_name", notes="\u7cfb\u7edf\u540d\u79f0")
        private String displayName;
        @JsonProperty(value="system_id")
        @JSONField(name="system_id")
        @ApiModelProperty(value="system_id", notes="\u7cfb\u7edf\u540d")
        private String systemId;
        @JsonProperty(value="roles")
        @JSONField(name="roles")
        @ApiModelProperty(value="roles", notes="\u89d2\u8272")
        private List<AuthGrantedRole> roles;

        public String getDeploySystemId() {
            return this.deploySystemId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public List<AuthGrantedRole> getRoles() {
            return this.roles;
        }

        @JsonProperty(value="deploy_system_id")
        public AuthGrantedSystem setDeploySystemId(String deploySystemId) {
            this.deploySystemId = deploySystemId;
            return this;
        }

        @JsonProperty(value="display_name")
        public AuthGrantedSystem setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @JsonProperty(value="system_id")
        public AuthGrantedSystem setSystemId(String systemId) {
            this.systemId = systemId;
            return this;
        }

        @JsonProperty(value="roles")
        public AuthGrantedSystem setRoles(List<AuthGrantedRole> roles) {
            this.roles = roles;
            return this;
        }
    }
}

