/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.rest;

import cn.ibizlab.util.domain.FileItem;
import cn.ibizlab.util.service.FileService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private FileService fileService;
    private final String defaultdownloadpath = "ibizutil/download/{id}";

    @PostMapping(value={"${ibiz.file.uploadpath:ibizutil/upload}"})
    public ResponseEntity<FileItem> upload(@RequestParam(value="file") MultipartFile multipartFile) {
        return ResponseEntity.ok().body((Object)this.fileService.saveFile(multipartFile));
    }

    @GetMapping(value={"${ibiz.file.downloadpath:ibizutil/download/{id}}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void download(@PathVariable String id, HttpServletResponse response) {
        File file = this.fileService.getFile(id);
        response.setHeader("Content-Disposition", "attachment;filename=" + this.getFileName(file.getName()));
        this.sendRespose(response, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRespose(HttpServletResponse response, File file) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String getFileName(String fileName) {
        try {
            return new String(fileName.getBytes("utf-8"), "iso8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return fileName;
        }
    }
}

