/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.rest;

import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.security.AuthorizationLogin;
import cn.ibizlab.util.service.AuthenticationUserService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class AppController {
    @Autowired
    private AuthenticationUserService userDetailsService;

    @PostMapping(value={"${ibiz.auth.path:v7/login}"})
    public ResponseEntity<AuthenticationInfo> login(@Validated @RequestBody AuthorizationLogin authorizationLogin) {
        this.userDetailsService.resetByUsername(authorizationLogin.getUsername());
        return ResponseEntity.ok().body((Object)this.userDetailsService.loadUserByLogin(authorizationLogin.getUsername(), authorizationLogin.getPassword()));
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"appdata"})
    public ResponseEntity<Map> getAppData() {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.userDetailsService.getAppData());
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"${ibiz.auth.logoutpath:v7/logout}"})
    public void logout() {
        if (AuthenticationUser.getAuthenticationUser() != null) {
            this.userDetailsService.resetByUsername(AuthenticationUser.getAuthenticationUser().getUsername());
        }
    }
}

