/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.helper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;

public final class JacksonUtils {
    public static ObjectMapper mapper = new ObjectMapper();

    public static String toJson(Object obj) {
        return mapper.writeValueAsString(obj);
    }

    public static <T> T toObj(Object obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (T)mapper.readValue(obj.toString(), clazz);
        }
        return (T)mapper.readValue(mapper.writeValueAsString(obj), clazz);
    }

    public static <T> T toObj(InputStream inputStream, Class<T> cls) {
        return (T)mapper.readValue(inputStream, cls);
    }

    public static <T> T toObj(String json, Class<T> cls) {
        return (T)mapper.readValue(json, cls);
    }

    public static <T> List<T> toArray(String jsonStr, Class<T> clazz) {
        CollectionType javaType = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
        return (List)mapper.readValue(jsonStr, (JavaType)javaType);
    }

    public static <T> List<T> toArray(Object obj, Class<T> clazz) {
        CollectionType javaType = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (List)mapper.readValue(obj.toString(), (JavaType)javaType);
        }
        return (List)mapper.readValue(mapper.writeValueAsString(obj), (JavaType)javaType);
    }

    public static <T> T toObj(String json, Type type) {
        return (T)mapper.readValue(json, mapper.constructType(type));
    }

    public static <T> T toObj(String json, TypeReference<T> typeReference) {
        return (T)mapper.readValue(json, typeReference);
    }

    public static <T> T toObj(InputStream inputStream, Type type) {
        return (T)mapper.readValue(inputStream, mapper.constructType(type));
    }

    public static JsonNode toObj(String json) {
        return mapper.readTree(json);
    }

    public static void registerSubtype(Class<?> clz, String type) {
        mapper.registerSubtypes(new NamedType[]{new NamedType(clz, type)});
    }

    public static ObjectNode createEmptyJsonNode() {
        return new ObjectNode(mapper.getNodeFactory());
    }

    public static ArrayNode createEmptyArrayNode() {
        return new ArrayNode(mapper.getNodeFactory());
    }

    public static JsonNode transferToJsonNode(Object obj) {
        return mapper.valueToTree(obj);
    }

    public static JavaType constructJavaType(Type type) {
        return mapper.constructType(type);
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

