/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.errors;

import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.errors.ErrorConstants;
import cn.ibizlab.util.errors.FieldErrorVM;
import cn.ibizlab.util.errors.NotFoundException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.ProblemHandling;
import org.zalando.problem.spring.web.advice.validation.ConstraintViolationProblem;

@ControllerAdvice
public class ExceptionTranslator
implements ProblemHandling {
    @Value(value="${spring.servlet.multipart.max-file-size}")
    private String maxFileSize;

    public ResponseEntity<Problem> process(@Nullable ResponseEntity<Problem> entity, NativeWebRequest request) {
        if (entity == null || entity.getBody() == null) {
            return entity;
        }
        Problem problem = (Problem)entity.getBody();
        if (!(problem instanceof ConstraintViolationProblem) && !(problem instanceof DefaultProblem)) {
            return entity;
        }
        ProblemBuilder builder = Problem.builder().withType(Problem.DEFAULT_TYPE.equals(problem.getType()) ? ErrorConstants.DEFAULT_TYPE : problem.getType()).withStatus(problem.getStatus()).withTitle(problem.getTitle()).with("path", (Object)((HttpServletRequest)request.getNativeRequest(HttpServletRequest.class)).getRequestURI());
        if (problem instanceof ConstraintViolationProblem) {
            builder.with("violations", (Object)((ConstraintViolationProblem)problem).getViolations()).with("message", (Object)"\u6570\u636e\u6821\u9a8c\u53d1\u751f\u9519\u8bef");
            return new ResponseEntity((Object)builder.build(), (MultiValueMap)entity.getHeaders(), entity.getStatusCode());
        }
        builder.withCause(((DefaultProblem)problem).getCause()).withDetail(problem.getDetail()).withInstance(problem.getInstance());
        problem.getParameters().forEach((arg_0, arg_1) -> ((ProblemBuilder)builder).with(arg_0, arg_1));
        if (!problem.getParameters().containsKey("message") && problem.getStatus() != null) {
            builder.with("message", (Object)("error.http." + problem.getStatus().getStatusCode()));
        }
        return new ResponseEntity((Object)builder.build(), (MultiValueMap)entity.getHeaders(), entity.getStatusCode());
    }

    public ResponseEntity<Problem> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, @Nonnull NativeWebRequest request) {
        BindingResult result = ex.getBindingResult();
        List fieldErrors = result.getFieldErrors().stream().map(f -> new FieldErrorVM(f.getObjectName(), f.getField(), f.getDefaultMessage())).collect(Collectors.toList());
        ThrowableProblem problem = Problem.builder().withType(ErrorConstants.CONSTRAINT_VIOLATION_TYPE).withTitle("\u6570\u636e\u6821\u9a8c\u53d1\u751f\u9519\u8bef").withStatus(this.defaultConstraintViolationStatus()).with("message", (Object)"\u6570\u636e\u6821\u9a8c\u53d1\u751f\u9519\u8bef").with("fieldErrors", fieldErrors).build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }

    @ExceptionHandler(value={BadRequestAlertException.class})
    public ResponseEntity<Problem> handleBadRequestAlertException(BadRequestAlertException ex, NativeWebRequest request) {
        return this.create((ThrowableProblem)ex, request, ExceptionTranslator.createFailureAlert(ex.getEntityName(), ex.getErrorKey(), ex.getMessage()));
    }

    @ExceptionHandler(value={NotFoundException.class})
    public ResponseEntity<Problem> handleNotFoundException(NotFoundException ex, NativeWebRequest request) {
        return this.create((ThrowableProblem)ex, request, ExceptionTranslator.createFailureAlert(ex.getEntityName(), ex.getErrorKey(), ex.getMessage()));
    }

    @ExceptionHandler(value={ConcurrencyFailureException.class})
    public ResponseEntity<Problem> handleConcurrencyFailure(ConcurrencyFailureException ex, NativeWebRequest request) {
        ThrowableProblem problem = Problem.builder().withStatus((StatusType)Status.CONFLICT).with("message", (Object)"\u5904\u7406\u8bf7\u6c42\u53d1\u751f\u9519\u8bef").build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }

    @ExceptionHandler(value={DataAccessException.class})
    public ResponseEntity<Problem> handlerDataAccessFailure(DataAccessException ex, NativeWebRequest request) {
        ThrowableProblem problem = Problem.builder().withStatus((StatusType)Status.INTERNAL_SERVER_ERROR).with("message", (Object)ex.getMessage()).build();
        return this.create((Throwable)ex, (Problem)problem, request, ExceptionTranslator.createFailureAlert(ex.getClass().getSimpleName(), ex.getClass().getSimpleName(), ex.getMessage()));
    }

    public static HttpHeaders createFailureAlert(String entityName, String errorKey, String defaultMessage) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-ibz-error", errorKey);
        headers.add("X-ibz-params", entityName);
        return headers;
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ResponseEntity<Problem> handlerMaxUploadFile(MaxUploadSizeExceededException ex, NativeWebRequest request) {
        ThrowableProblem problem = Problem.builder().withStatus((StatusType)Status.BAD_REQUEST).withDetail("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e" + this.maxFileSize).with("message", (Object)("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e" + this.maxFileSize)).with("exmessage", (Object)("" + ex.getMessage())).build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Problem> handlerTest(Exception ex, NativeWebRequest request) {
        ThrowableProblem problem = Problem.builder().withStatus((StatusType)Status.INTERNAL_SERVER_ERROR).withDetail("\u5185\u90e8\u670d\u52a1\u5668\u5f02\u5e38").with("message", (Object)"\u5185\u90e8\u670d\u52a1\u5668\u5f02\u5e38").with("exmessage", (Object)("" + ex.getMessage())).build();
        return this.create(ex, (Problem)problem, request);
    }
}

