/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.client;

import cn.ibizlab.util.security.AuthUser20Impl;
import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthorizationLogin;
import java.util.List;
import java.util.Map;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@FeignClient(value="${ibiz.ref.service.uaa:uaa-api}", contextId="uaa20", url="${ibiz.ref.service.rt.url:}")
public interface UaaFeignClient {
    @PostMapping(value={"/sys_deploy_systems/save"}, consumes={"application/json"})
    public ResponseEntity<String> deploySystem(@RequestHeader Map<String, Object> var1, @RequestBody String var2);

    @PostMapping(value={"/sys_deploy_systems/deployresource/{system}"})
    public String deployResource(@PathVariable(value="system") String var1, @RequestBody byte[] var2);

    @PostMapping(value={"/auths/login"})
    public AuthenticationInfo login(@RequestHeader(value="Authorization") String var1, @RequestBody AuthorizationLogin var2);

    default public AuthenticationInfo login(AuthorizationLogin authorizationLogin) {
        return this.login("NONE", authorizationLogin);
    }

    @PostMapping(value={"/auths/{username}/logout"})
    public Boolean uaaLogout(@RequestHeader(value="Authorization") String var1, @PathVariable(value="username") String var2);

    default public Boolean uaaLogout(String username) {
        return this.uaaLogout("NONE", username);
    }

    @PostMapping(value={"/auths/{username}/loaduserbyusername"})
    public AuthUser20Impl loadUserByUsername(@PathVariable(value="username") String var1);

    @Cacheable(value={"ibzuaa_signaturekey"})
    @PostMapping(value={"/auths/signaturekey"})
    public String signatureKey();

    @Cacheable(value={"sysorganization"}, key="'orginfo:'+#p0+':'+#p1")
    @PostMapping(value={"auths/{organizationId}/{departmentId}/orginfo"})
    public Map<String, List<String>> getOrgInfo(@PathVariable(value="organizationId") String var1, @PathVariable(value="departmentId") String var2);
}

