/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.client;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignRequestInterceptor
implements RequestInterceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void apply(RequestTemplate requestTemplate) {
        HttpServletRequest request;
        Enumeration headerNames;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && (headerNames = (request = requestAttributes.getRequest()).getHeaderNames()) != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                if (name.equalsIgnoreCase("transfer-encoding")) continue;
                String values = request.getHeader(name);
                requestTemplate.header(name, new String[]{values});
            }
            this.logger.info("feign interceptor header:{}", (Object)requestTemplate);
        }
    }
}

