/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.cache.listener;

import cn.ibizlab.util.cache.cache.LayeringCache;
import cn.ibizlab.util.cache.listener.RedisChannelTopic;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.ObjectUtils;

public class RedisMessageListener
extends MessageListenerAdapter {
    private static final Logger log = LoggerFactory.getLogger(RedisMessageListener.class);
    private CacheManager cacheManager;
    private RedisTemplate redisTemplate;

    public RedisMessageListener(CacheManager cacheManager, RedisTemplate redisTemplate) {
        this.cacheManager = cacheManager;
        this.redisTemplate = redisTemplate;
    }

    public void onMessage(Message message, byte[] pattern) {
        RedisChannelTopic channelTopic = RedisChannelTopic.getChannelTopicEnum(new String(message.getChannel()));
        Map map = null;
        RedisSerializer serializer = this.redisTemplate.getValueSerializer();
        Object result = serializer.deserialize(message.getBody());
        if (result instanceof Map) {
            map = (Map)result;
        }
        if (ObjectUtils.isEmpty(map) || !map.containsKey("cacheName")) {
            log.debug("\u89e3\u6790\u7f13\u5b58\u6570\u636e\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u503c!");
            return;
        }
        log.debug("redis\u6d88\u606f\u8ba2\u9605\u8005\u63a5\u6536\u5230\u9891\u9053\u3010{}\u3011\u53d1\u5e03\u7684\u6d88\u606f\u3002\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)channelTopic.getChannelTopicStr(), (Object)result.toString());
        String cacheName = (String)map.get("cacheName");
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache != null && cache instanceof LayeringCache) {
            switch (channelTopic) {
                case REDIS_CACHE_DELETE_TOPIC: {
                    Object cacheKey = map.get("key");
                    if (!ObjectUtils.isEmpty(cacheKey)) {
                        ((LayeringCache)cache).getFirstCache().evict(cacheKey);
                        ((LayeringCache)cache).getSecondCache().evict(cacheKey);
                        log.debug("\u540c\u6b65\u5220\u9664\u7f13\u5b58{}\u6570\u636e,key:{},", (Object)cacheName, (Object)cacheKey.toString());
                        break;
                    }
                    log.debug("\u540c\u6b65\u5220\u9664\u7f13\u5b58\u5931\u8d25\uff0c{}\u7f13\u5b58\u952e\u503c\u4e3a\u7a7a!", (Object)cacheName);
                    break;
                }
                case REDIS_CACHE_CLEAR_TOPIC: {
                    ((LayeringCache)cache).getFirstCache().clear();
                    ((LayeringCache)cache).getSecondCache().clear();
                    log.debug("\u540c\u6b65\u6e05\u9664\u7f13\u5b58{}\u6570\u636e", (Object)cacheName);
                    break;
                }
                default: {
                    log.debug("\u63a5\u6536\u5230\u6ca1\u6709\u5b9a\u4e49\u7684\u8ba2\u9605\u6d88\u606f\u9891\u9053\u6570\u636e");
                }
            }
        }
    }
}

