/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.cache.cacheManager;

import cn.ibizlab.util.cache.cache.CusCaffeineCache;
import cn.ibizlab.util.cache.cache.CusRedisCache;
import cn.ibizlab.util.cache.cache.LayeringCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.ObjectUtils;

public class LayeringCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>(16);
    private static final int DEFAULT_EXPIRE_AFTER_WRITE = 1;
    private static final int DEFAULT_INITIAL_CAPACITY = 5;
    private static final int DEFAULT_MAXIMUM_SIZE = 1000;
    private Caffeine<Object, Object> cacheBuilder = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).initialCapacity(5).maximumSize(1000L);
    private RedisCacheWriter redisCacheWriter;
    private RedisCacheConfiguration redisConfiguration;
    private RedisTemplate<String, Object> redisTemplate;

    public LayeringCacheManager(RedisCacheWriter redisCacheWriter, RedisCacheConfiguration redisConfiguration, RedisTemplate<String, Object> redisTemplate) {
        this.redisCacheWriter = redisCacheWriter;
        this.redisConfiguration = redisConfiguration;
        this.redisTemplate = redisTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String cacheName) {
        Cache cache = (Cache)this.cacheMap.get(cacheName);
        if (cache == null) {
            ConcurrentMap<String, Cache> concurrentMap = this.cacheMap;
            synchronized (concurrentMap) {
                cache = (Cache)this.cacheMap.get(cacheName);
                if (cache == null) {
                    cache = this.createCache(cacheName);
                    this.cacheMap.put(cacheName, cache);
                }
            }
        }
        return cache;
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    protected Cache createCache(String cacheName) {
        return new LayeringCache(cacheName, new CusCaffeineCache(cacheName, (com.github.benmanes.caffeine.cache.Cache<Object, Object>)this.cacheBuilder.build(), true), new CusRedisCache(cacheName, this.redisCacheWriter, this.redisConfiguration), (RedisOperations<String, Object>)this.redisTemplate);
    }

    public void setCaffeineCacheConfig(CaffeineSpec caffeineCacheConfig) {
        Caffeine cacheBuilder = Caffeine.from((CaffeineSpec)caffeineCacheConfig);
        if (!ObjectUtils.nullSafeEquals(this.cacheBuilder, (Object)cacheBuilder)) {
            this.cacheBuilder = cacheBuilder;
        }
    }

    public ConcurrentMap<String, Cache> getCacheMap() {
        return this.cacheMap;
    }

    public Caffeine<Object, Object> getCacheBuilder() {
        return this.cacheBuilder;
    }

    public RedisCacheWriter getRedisCacheWriter() {
        return this.redisCacheWriter;
    }

    public RedisCacheConfiguration getRedisConfiguration() {
        return this.redisConfiguration;
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setCacheBuilder(Caffeine<Object, Object> cacheBuilder) {
        this.cacheBuilder = cacheBuilder;
    }

    public void setRedisCacheWriter(RedisCacheWriter redisCacheWriter) {
        this.redisCacheWriter = redisCacheWriter;
    }

    public void setRedisConfiguration(RedisCacheConfiguration redisConfiguration) {
        this.redisConfiguration = redisConfiguration;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LayeringCacheManager)) {
            return false;
        }
        LayeringCacheManager other = (LayeringCacheManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConcurrentMap<String, Cache> this$cacheMap = this.getCacheMap();
        ConcurrentMap<String, Cache> other$cacheMap = other.getCacheMap();
        if (this$cacheMap == null ? other$cacheMap != null : !this$cacheMap.equals(other$cacheMap)) {
            return false;
        }
        Caffeine<Object, Object> this$cacheBuilder = this.getCacheBuilder();
        Caffeine<Object, Object> other$cacheBuilder = other.getCacheBuilder();
        if (this$cacheBuilder == null ? other$cacheBuilder != null : !this$cacheBuilder.equals(other$cacheBuilder)) {
            return false;
        }
        RedisCacheWriter this$redisCacheWriter = this.getRedisCacheWriter();
        RedisCacheWriter other$redisCacheWriter = other.getRedisCacheWriter();
        if (this$redisCacheWriter == null ? other$redisCacheWriter != null : !this$redisCacheWriter.equals(other$redisCacheWriter)) {
            return false;
        }
        RedisCacheConfiguration this$redisConfiguration = this.getRedisConfiguration();
        RedisCacheConfiguration other$redisConfiguration = other.getRedisConfiguration();
        if (this$redisConfiguration == null ? other$redisConfiguration != null : !this$redisConfiguration.equals(other$redisConfiguration)) {
            return false;
        }
        RedisTemplate<String, Object> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, Object> other$redisTemplate = other.getRedisTemplate();
        return !(this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LayeringCacheManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentMap<String, Cache> $cacheMap = this.getCacheMap();
        result = result * 59 + ($cacheMap == null ? 43 : $cacheMap.hashCode());
        Caffeine<Object, Object> $cacheBuilder = this.getCacheBuilder();
        result = result * 59 + ($cacheBuilder == null ? 43 : $cacheBuilder.hashCode());
        RedisCacheWriter $redisCacheWriter = this.getRedisCacheWriter();
        result = result * 59 + ($redisCacheWriter == null ? 43 : $redisCacheWriter.hashCode());
        RedisCacheConfiguration $redisConfiguration = this.getRedisConfiguration();
        result = result * 59 + ($redisConfiguration == null ? 43 : $redisConfiguration.hashCode());
        RedisTemplate<String, Object> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "LayeringCacheManager(cacheMap=" + this.getCacheMap() + ", cacheBuilder=" + this.getCacheBuilder() + ", redisCacheWriter=" + this.getRedisCacheWriter() + ", redisConfiguration=" + this.getRedisConfiguration() + ", redisTemplate=" + this.getRedisTemplate() + ")";
    }
}

