/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.cache.cacheManager;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.util.ObjectUtils;

public class CaffeineCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>(16);
    private static final int DEFAULT_EXPIRE_AFTER_WRITE = 1;
    private static final int DEFAULT_INITIAL_CAPACITY = 5;
    private static final int DEFAULT_MAXIMUM_SIZE = 1000;
    private Caffeine<Object, Object> cacheBuilder = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).initialCapacity(5).maximumSize(1000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String cacheName) {
        Cache cache = (Cache)this.cacheMap.get(cacheName);
        if (cache == null) {
            ConcurrentMap<String, Cache> concurrentMap = this.cacheMap;
            synchronized (concurrentMap) {
                cache = (Cache)this.cacheMap.get(cacheName);
                if (cache == null) {
                    cache = this.createCache(cacheName);
                    this.cacheMap.put(cacheName, cache);
                }
            }
        }
        return cache;
    }

    protected Cache createCache(String cacheName) {
        return new CaffeineCache(cacheName, this.cacheBuilder.build(), true);
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    public void setCaffeineCacheConfig(CaffeineSpec caffeineCacheConfig) {
        Caffeine cacheBuilder = Caffeine.from((CaffeineSpec)caffeineCacheConfig);
        if (!ObjectUtils.nullSafeEquals(this.cacheBuilder, (Object)cacheBuilder)) {
            this.cacheBuilder = cacheBuilder;
        }
    }

    public ConcurrentMap<String, Cache> getCacheMap() {
        return this.cacheMap;
    }

    public Caffeine<Object, Object> getCacheBuilder() {
        return this.cacheBuilder;
    }

    public void setCacheBuilder(Caffeine<Object, Object> cacheBuilder) {
        this.cacheBuilder = cacheBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaffeineCacheManager)) {
            return false;
        }
        CaffeineCacheManager other = (CaffeineCacheManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConcurrentMap<String, Cache> this$cacheMap = this.getCacheMap();
        ConcurrentMap<String, Cache> other$cacheMap = other.getCacheMap();
        if (this$cacheMap == null ? other$cacheMap != null : !this$cacheMap.equals(other$cacheMap)) {
            return false;
        }
        Caffeine<Object, Object> this$cacheBuilder = this.getCacheBuilder();
        Caffeine<Object, Object> other$cacheBuilder = other.getCacheBuilder();
        return !(this$cacheBuilder == null ? other$cacheBuilder != null : !this$cacheBuilder.equals(other$cacheBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CaffeineCacheManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentMap<String, Cache> $cacheMap = this.getCacheMap();
        result = result * 59 + ($cacheMap == null ? 43 : $cacheMap.hashCode());
        Caffeine<Object, Object> $cacheBuilder = this.getCacheBuilder();
        result = result * 59 + ($cacheBuilder == null ? 43 : $cacheBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "CaffeineCacheManager(cacheMap=" + this.getCacheMap() + ", cacheBuilder=" + this.getCacheBuilder() + ")";
    }
}

