/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.cache.cache;

import cn.ibizlab.util.cache.listener.RedisChannelTopic;
import cn.ibizlab.util.cache.listener.RedisPublisher;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.cache.support.NullValue;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.ObjectUtils;

public class LayeringCache
extends AbstractValueAdaptingCache {
    private static final Logger log = LoggerFactory.getLogger(LayeringCache.class);
    private String cacheName;
    private CaffeineCache caffeineCache;
    private RedisCache redisCache;
    RedisOperations<? extends Object, ? extends Object> redisOperations;

    public LayeringCache(String cacheName, CaffeineCache caffeineCache, RedisCache redisCache, RedisOperations<String, Object> redisOperations) {
        super(true);
        this.cacheName = cacheName;
        this.caffeineCache = caffeineCache;
        this.redisCache = redisCache;
        this.redisOperations = redisOperations;
    }

    public String getName() {
        return this.cacheName;
    }

    public Object getNativeCache() {
        return this;
    }

    public Cache.ValueWrapper get(Object key) {
        Cache.ValueWrapper wrapper = this.caffeineCache.get(key);
        Object value = ObjectUtils.isEmpty((Object)wrapper) ? null : wrapper.get();
        log.debug("\u67e5\u8be2\u4e00\u7ea7\u7f13\u5b58 key:{} ", key, value);
        if (ObjectUtils.isEmpty((Object)value)) {
            wrapper = this.redisCache.get(key);
            value = ObjectUtils.isEmpty((Object)wrapper) ? null : wrapper.get();
            log.debug("\u67e5\u8be2\u4e8c\u7ea7\u7f13\u5b58 key:{} ", key);
            if (!ObjectUtils.isEmpty((Object)value)) {
                this.caffeineCache.put(key, value);
                log.debug("\u67e5\u8be2\u4e8c\u7ea7\u7f13\u5b58\uff0c\u5e76\u5c06\u6570\u636e\u653e\u5230\u4e00\u7ea7\u7f13\u5b58\u3002 key:{} ", key);
            }
        }
        return wrapper;
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.caffeineCache.get(key, type);
        log.debug("\u67e5\u8be2\u4e00\u7ea7\u7f13\u5b58 key:{}", key);
        if (value == null) {
            value = this.redisCache.get(key, type);
            this.caffeineCache.put(key, value);
            log.debug("\u67e5\u8be2\u4e8c\u7ea7\u7f13\u5b58,\u5e76\u5c06\u6570\u636e\u653e\u5230\u4e00\u7ea7\u7f13\u5b58\u3002 key:{}", key);
        }
        return (T)value;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.caffeineCache.getNativeCache().get(key, k -> this.getSecondCacheValue(k, valueLoader));
        if (value == null) {
            value = this.getSecondCacheValue(key, valueLoader);
        }
        if (value instanceof NullValue) {
            return null;
        }
        return (T)value;
    }

    public void put(Object key, Object value) {
        if (value != null) {
            this.caffeineCache.put(key, value);
            this.redisCache.put(key, value);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        this.caffeineCache.putIfAbsent(key, value);
        return this.redisCache.putIfAbsent(key, value);
    }

    public void evict(Object key) {
        this.redisCache.evict(key);
        this.caffeineCache.evict(key);
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("cacheName", this.cacheName);
        message.put("key", key);
        RedisPublisher redisPublisher = new RedisPublisher(this.redisOperations, RedisChannelTopic.REDIS_CACHE_DELETE_TOPIC.getChannelTopic());
        redisPublisher.publisher(message);
        log.debug(String.format("\u6e05\u9664\u4e8c\u7ea7\u7f13\u5b58\u6570\u636e[%s]", key));
    }

    public void clear() {
        this.redisCache.clear();
        this.caffeineCache.clear();
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("cacheName", this.cacheName);
        RedisPublisher redisPublisher = new RedisPublisher(this.redisOperations, RedisChannelTopic.REDIS_CACHE_CLEAR_TOPIC.getChannelTopic());
        redisPublisher.publisher(message);
    }

    protected Object lookup(Object key) {
        Cache.ValueWrapper value = this.caffeineCache.get(key);
        log.debug("\u67e5\u8be2\u4e00\u7ea7\u7f13\u5b58 key:{}", key);
        if (value == null) {
            value = this.redisCache.get(key);
            log.debug("\u67e5\u8be2\u4e8c\u7ea7\u7f13\u5b58 key:{}", key);
        }
        return value;
    }

    public CaffeineCache getFirstCache() {
        return this.caffeineCache;
    }

    public RedisCache getSecondCache() {
        return this.redisCache;
    }

    private <T> Object getSecondCacheValue(Object key, Callable<T> valueLoader) {
        Object value = this.redisCache.get(key, valueLoader);
        log.debug("\u67e5\u8be2\u4e8c\u7ea7\u7f13\u5b58 key:{}", key);
        return this.toStoreValue(value);
    }
}

