/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.cache;

import cn.ibizlab.util.cache.cacheManager.CaffeineCacheManager;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;

@EnableCaching
@Configuration
@EnableConfigurationProperties(value={CacheProperties.class})
@ConditionalOnExpression(value="'${ibiz.cacheLevel:None}'.equals('L1')")
public class CaffeineCacheConfig {
    @Bean
    @Primary
    public CacheManager cacheManager(CacheProperties cacheProperties) {
        CaffeineCacheManager caffeineCacheManager = new CaffeineCacheManager();
        String strCacheConfig = cacheProperties.getCaffeine().getSpec();
        if (StringUtils.hasText((String)strCacheConfig)) {
            caffeineCacheManager.setCaffeineCacheConfig(CaffeineSpec.parse((String)strCacheConfig));
        }
        return caffeineCacheManager;
    }
}

