package cn.ibizlab.util.security;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;

import java.io.Serializable;

@Getter
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel(value = "authentication_info", description = "认证信息")
public class AuthenticationInfo implements Serializable {
    private String token;
    private AuthInfo user;

    @Getter
    @Setter
    @NoArgsConstructor
    @Accessors(chain = true)
    @JsonIgnoreProperties(value = "handler")
    @ApiModel(value = "auth_info", description = "用户信息")
    public static class AuthInfo  implements Serializable {

        /**
         * 用户标识
         */
        @Id
        @JsonProperty("id")
        @JSONField(name = "id")
        @ApiModelProperty(value = "id", notes = "用户标识")
        private String id;

        /**
         * 用户显示名
         */
        @JsonProperty("display_name")
        @JSONField(name = "display_name")
        @ApiModelProperty(value = "display_name", notes = "用户显示名")
        private String displayName;

        /**
         * username/uid
         */
        @JsonProperty("username")
        @JSONField(name = "username")
        @ApiModelProperty(value = "username", notes = "username/uid")
        private String username;

        /**
         * DC
         */
        @JsonProperty("dc")
        @JSONField(name = "dc")
        @ApiModelProperty(value = "dc", notes = "DC")
        private String dc;

        /**
         * 组织机构标识
         */
        @JsonProperty("organization_id")
        @JSONField(name = "organization_id")
        @ApiModelProperty(value = "organization_id", notes = "组织机构标识")
        private String organizationId;

        /**
         * 电子邮箱
         */
        @JsonProperty("mail")
        @JSONField(name = "mail")
        @ApiModelProperty(value = "mail", notes = "电子邮箱")
        private String mail;

        /**
         * 移动电话
         */
        @JsonProperty("mobile")
        @JSONField(name = "mobile")
        @ApiModelProperty(value = "mobile", notes = "移动电话")
        private String mobile;

    }

}
