package cn.ibizlab.util.security;

import org.springframework.util.Assert;

final class AuthenticationContextHolder  {
    private static final ThreadLocal<AuthenticationUser> contextHolder = new ThreadLocal();

    AuthenticationContextHolder() {
    }

    public static void clearContext() {
        contextHolder.remove();
    }

    public static AuthenticationUser getContext() {
        AuthenticationUser ctx = (AuthenticationUser)contextHolder.get();

        return ctx;
    }

    public static void setContext(AuthenticationUser context) {
        Assert.notNull(context, "Only non-null AuthenticationUser instances are permitted");
        contextHolder.set(context);
    }

}
