package cn.ibizlab.util.domain;


import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.ObjectUtils;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class Option
{
	private String id;
	private Object value;
	private String label;
	private List<Option> children;
	private String iconClass;
	private String filter;
	private Boolean disabled;
	@JsonIgnore
	@JSONField(serialize = false)
	private String parent;
	private Map<String, Object> extension;

	@JsonIgnore
	@JSONField(serialize = false)
	private Set<String> filterSet;
	public Set<String> getFilterSet()
	{
		if(filterSet==null)
			filterSet=!ObjectUtils.isEmpty(filter)?new HashSet<>(Arrays.asList(filter.split(";|,"))):new HashSet<>();
		return filterSet;
	}
}
