package cn.ibizlab.util.domain;


import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.ObjectUtils;
import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class Catalog
{
	private String code;
	private String name;

	@JSONField(name = "items")
	@JsonProperty("items")
	private List<Option> options = new ArrayList<>();

	public Option findItem(Object value)
	{
		return findItem(value,this.options);
	}

	public Option findItem(Object value, List<Option> options){
		for(Option codeItem : options){
			if(value != null && codeItem.getValue() != null && value.equals(codeItem.getValue()))
				return codeItem;
			else if (!ObjectUtils.isEmpty(codeItem.getChildren()))
			{
				Option rt=findItem(value,codeItem.getChildren());
				if(rt!=null)
					return rt;
			}
		}
		return null;
	}

}
