package cn.ibizlab.util.domain;

import cn.hutool.core.io.file.FileNameUtil;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import io.swagger.annotations.ApiModel;
import lombok.*;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author ibizlab
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonInclude(Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@AllArgsConstructor
@ApiModel(value = "FileItem", description = "文件对象")
public class FileItem
{
	private String id;
	private String name;
	private String version;
	public String getVersion(){
		if(version==null) {
			String mainName=FileNameUtil.mainName(getName());
			if(mainName!=null&&mainName.indexOf("v")>0)
				version=mainName.substring(mainName.lastIndexOf("v"));
		}
		return version;
	}
	private String author;
	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
	@JSONField(format="yyyy-MM-dd HH:mm:ss")
	private Date time;
	private Long size;
	private String ext;
	public String getExt(){
		if(ext==null) {
			ext= FileNameUtil.extName(getName());
		}
		return ext;
	}
}
