package cn.ibizlab.util.client;

import cn.ibizlab.util.security.*;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@FeignClient(value = "${ibiz.ref.service.uaa:uaa-api}",contextId = "uaa20",url = "${ibiz.ref.service.rt.url:}")
public interface UaaFeignClient {

    @PostMapping(value = "/sys_deploy_systems/save",consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseEntity<String> deploySystem(@RequestHeader Map<String, Object> headers, @RequestBody String requestBody);

    @PostMapping("/sys_deploy_systems/deployresource/{system}")
    String deployResource(@PathVariable("system") String system, @RequestBody byte[] resource);

    @PostMapping("/auths/login")
    AuthenticationInfo login(@RequestHeader("Authorization") String token,@RequestBody AuthorizationLogin authorizationLogin);

    default AuthenticationInfo login(AuthorizationLogin authorizationLogin) {
        return login("NONE",authorizationLogin);
    }

    @PostMapping(value = "/auths/{username}/logout")
    Boolean uaaLogout(@RequestHeader("Authorization") String token, @PathVariable("username") String username);

    default Boolean uaaLogout(String username) {
        return uaaLogout("NONE",username);
    }

    @PostMapping("/auths/{username}/loaduserbyusername")
    AuthUser20Impl loadUserByUsername(@PathVariable("username") String username);

    @Cacheable(value="ibzuaa_signaturekey")
    @PostMapping("/auths/signaturekey")
    String signatureKey();

    @Cacheable(value = "sysorganization", key = "'orginfo:'+#p0+':'+#p1")
    @PostMapping("auths/{organizationId}/{departmentId}/orginfo")
    public Map<String,List<String>> getOrgInfo(@PathVariable("organizationId") String organizationId, @PathVariable("departmentId") String departmentId);

}
