package cn.ibizlab.util.client;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.LinkedHashMap;
import java.util.Map;

@FeignClient(value = "${ibiz.ref.service.wf:workflow-api}",contextId = "flow20",url = "${ibiz.ref.service.rt.wf.url:}")
public interface FlowFeignClient {

    @PostMapping("/wf_process_definitions/deploybpmn/{system}")
    Boolean deployBpmn(@PathVariable("system") String system, @RequestBody LinkedHashMap<String, byte[]> bpmns);

    @PostMapping("/wf_tasks/todokeys")
    LinkedHashMap<String,Object> toDoKeys(@RequestBody LinkedHashMap map);

    default Map<String,Map<String,Object>> toDoKeys(String system,String entity,String processDefinitionKey,String taskDefinitionKey,String taskDefinitionName) {
        Map<String,Map<String,Object>> keys = new LinkedHashMap<>();
        LinkedHashMap param=new LinkedHashMap();
        param.put("system",system);
        param.put("entity",entity);
        param.put("process_definition_key",processDefinitionKey);
        param.put("task_definition_key",taskDefinitionKey);
        param.put("task_definition_name",taskDefinitionName);
        LinkedHashMap<String,Object> ret = toDoKeys(param);
        if(!ObjectUtils.isEmpty(ret)) {
            ret.entrySet().forEach(entry->{
                if(entry.getValue() instanceof Map) {
                    keys.put(entry.getKey(),(Map)entry.getValue());
                }
            });
        }
        return keys;
    }

}
