package cn.ibizlab.util.service;

import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClock;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.ObjectUtils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;

public interface UserServiceAdapter {

    static DateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    default AuthenticationUser loadUserByUsername(String username){
        return null ;
    }

    default AuthenticationInfo loadUserByLogin(String username, String password){
        return null ;
    }

    default Map getAppData(String systemId,boolean isEnablePermissionValid)
    {

        Map appData = new HashMap() ;
        Set<String> appMenu = new HashSet();
        Set<String> uniRes = new HashSet();

        AuthenticationUser curUser = AuthenticationUser.getAuthenticationUser();
        if(isEnablePermissionValid&&(!ObjectUtils.isEmpty(systemId))){
            Collection<GrantedAuthority> authorities=curUser.getAuthorities();
            Iterator it = authorities.iterator();
            while(it.hasNext()) {
                GrantedAuthority authority = (GrantedAuthority)it.next();
                String strAuthority=authority.getAuthority();
                if(strAuthority.startsWith("UNIRES_"+systemId)) {
                    uniRes.add(strAuthority.substring(systemId.length()+8));
                }
                else if(strAuthority.startsWith("APPMENU_"+systemId)){
                    appMenu.add(strAuthority.substring(systemId.length()+9));
                }
            }
        }
        if (!ObjectUtils.isEmpty(curUser.getExpiration())) {
            appData.put("expireddate", dtFormat.format(curUser.getExpiration()));
        }
        Map<String,Object> context = new HashMap<>();
        context.putAll(curUser.getSessionParams());
        context.put("srfusername",curUser.getPersonName());
        appData.put("context",context);
        appData.put("unires",uniRes);
        appData.put("appmenu",appMenu);
        appData.put("enablepermissionvalid",isEnablePermissionValid);
        if(curUser.isSuperUser()){
            appData.put("enablepermissionvalid",false);
        }
        else{
            appData.put("enablepermissionvalid",isEnablePermissionValid);
        }
        return appData;
    }

    default String getSecret() {
        return "ibzsecret";
    }

    default Long getExpiration() {
        return 7200000L;
    }

    default String generateToken(UserDetails userDetails) {
        Map<String, Object> claims = new HashMap<>();
        final Date createdDate = DefaultClock.INSTANCE.now();
        final Date expirationDate = new Date(createdDate.getTime() + getExpiration());

        return Jwts.builder()
                .setClaims(claims)
                .setSubject(userDetails.getUsername())
                .setIssuedAt(createdDate)
                .setExpiration(expirationDate)
                .signWith(SignatureAlgorithm.HS512, getSecret())
                .compact();
    }

    default String getUsernameFromToken(String token) {
        return getClaimFromToken(token, Claims::getSubject);
    }

    default Date getExpirationDateFromToken(String token) {
        return getClaimFromToken(token, Claims::getExpiration);
    }

    default <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        final Claims claims = Jwts.parser()
                .setSigningKey(getSecret())
                .parseClaimsJws(token)
                .getBody();
        return claimsResolver.apply(claims);
    }


    default String refreshToken(String token) {
        final Date createdDate = DefaultClock.INSTANCE.now();
        final Date expirationDate = new Date(createdDate.getTime() + getExpiration());
        final Claims claims = Jwts.parser()
                .setSigningKey(getSecret())
                .parseClaimsJws(token)
                .getBody();;
        return Jwts.builder()
                .setClaims(claims)
                .setIssuedAt(createdDate)
                .setExpiration(expirationDate)
                .signWith(SignatureAlgorithm.HS512, getSecret())
                .compact();
    }

    default Boolean validateToken(String token, UserDetails userDetails) {
        AuthenticationUser user = (AuthenticationUser) userDetails;
        user.setToken(token);
        final Date expiration = getExpirationDateFromToken(token);
        user.setExpiration(expiration);
        return !expiration.before(DefaultClock.INSTANCE.now());
    }



}
