package cn.ibizlab.util.service;

import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.security.AuthenticationUserImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Primary;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.stereotype.Service;

/**
 * 实体[IBZUSER] 服务对象接口实现
 */
@Primary
@Service("SimpleUserService")
@ConditionalOnExpression("('${ibiz.ref.service.rt.version:}'.equals('NONE') || !${ibiz.enablePermissionValid:false})&&'${ibiz.auth.service:SimpleUserService}'.equals('SimpleUserService')")
public class SimpleUserService implements UserServiceAdapter {

	@Override
	public AuthenticationUser loadUserByUsername(String username) {
		AuthenticationUserImpl user = new AuthenticationUserImpl();
		String[] data = username.split("[|]");
		String loginname = username;
		String domains = "";
		String password = "";

		if(data.length==2) {
			loginname = data[0].trim();
			domains = data[1].trim();
		}

		user.setUserid(username);
		user.setUserCode(loginname);
		user.setUsername(username);
		user.setLoginName(loginname);
		user.setPersonName(loginname);
		user.setDomain(domains);
		user.setPassword(password);
		user.setOrgId(domains);
		user.setOrgCode(domains);
		user.setOrgName(domains);
		user.setSuperUser(1);
		user.setAuthorities(AuthorityUtils.createAuthorityList("ROLE_SUPERADMIN"));

		return user;
	}

	@Override
	public AuthenticationInfo loadUserByLogin(String username, String password) {
		AuthenticationUser authuserdetail = loadUserByUsername(username);
		final String token = generateToken(authuserdetail);
		// 返回 token
		return new AuthenticationInfo(token,authuserdetail);
	}


}
