package cn.ibizlab.util.service;

import cn.ibizlab.util.client.IBZUAAFeignClient;
import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.security.AuthorizationLogin;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultClock;
import lombok.SneakyThrows;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.function.Function;

/**
 * 实体[IBZUSER] 服务对象接口实现
 */
@Service("IBZUAAUserService")
@ConditionalOnExpression("(!'${ibiz.ref.service.rt.version:}'.equals('RT2')) && ${ibiz.enablePermissionValid:false} &&'${ibiz.auth.service:IBZUAAUserService}'.equals('IBZUAAUserService')")
public class IBZUAAUserService implements UserServiceAdapter {

	@Autowired
	private IBZUAAFeignClient uaaFeignClient;

	@Override
	public AuthenticationUser loadUserByUsername(String username) {
		AuthenticationUser user = uaaFeignClient.loginByUsername(username);
		if(user == null) {
			throw new BadRequestAlertException("登录失败","IBZUAAUser",username);
		}
		return user;
	}

	@Override
	public AuthenticationInfo loadUserByLogin(String username, String password) {
		String[] data = username.split("[|]");
		String loginname = username;
		String domains = "";

		if(data.length==2) {
			loginname=data[0].trim();
			domains=data[1].trim();
		}
		AuthorizationLogin logininfo = new AuthorizationLogin();
		logininfo.setDomain(domains);
		logininfo.setLoginname(loginname);
		logininfo.setPassword(password);
		AuthenticationInfo info = uaaFeignClient.v7Login(logininfo);
		if(info.getUser() == null){
			throw new BadRequestAlertException("登录失败","IBZUAAUser", username);
		}
		return info;
	}


	private Clock clock = DefaultClock.INSTANCE;

	@Value("${ibiz.jwt.expiration:7200000}")
	private Long expiration;

	@Override
	public String getSecret() {
		return getPublicKeyString();
	}

	@Override
	public Long getExpiration() {
		return expiration;
	}

	public String getUsernameFromToken(String token) {
		return getClaimFromToken(token, Claims::getSubject);
	}

	public Date getExpirationDateFromToken(String token) {
		return getClaimFromToken(token, Claims::getExpiration);
	}

	public <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
		final Claims claims = getAllClaimsFromToken(token);
		return claimsResolver.apply(claims);
	}

	public Claims getAllClaimsFromToken(String token) {
		PublicKey publicKey = getPublicKey(getPublicKeyString());
		return Jwts.parser()
				.setSigningKey(publicKey)
				.parseClaimsJws(token)
				.getBody();
	}


	public String generateToken(UserDetails userDetails) {
		return null;
	}

	@Override
	public String refreshToken(String token) {
		return null;
	}

	public Boolean validateToken(String token, UserDetails userDetails) {
		AuthenticationUser user = (AuthenticationUser) userDetails;
		user.setToken(token);
		final Date expiration = getExpirationDateFromToken(token);
		user.setExpiration(expiration);
		return !expiration.before(clock.now());

	}

	private String getPublicKeyString(){
		return uaaFeignClient.getPublicKey();
	}

	@SneakyThrows
	public PublicKey getPublicKey(String publicKeyBase64) {
		byte[] byteKey = Base64.decodeBase64(publicKeyBase64);
		X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byteKey);
		KeyFactory keyFactory = KeyFactory.getInstance("RSA");
		return keyFactory.generatePublic(x509EncodedKeySpec);
	}

}
