package cn.ibizlab.util.security;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class UAARoleAuthority extends UAAGrantedAuthority {

    private String roleTag;

    public UAARoleAuthority(){
        this.setType("ROLE");
    }

    @Override
    public String getAuthority() {
        return roleTag==null||roleTag.startsWith("ROLE_")?roleTag:("ROLE_"+roleTag);
    }

    public void setAuthority(String roleTag) {
        this.roleTag = roleTag;
    }

}

