package cn.ibizlab.util.security;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import org.springframework.util.ObjectUtils;

import java.util.*;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class UAACustomAuthority extends UAAGrantedAuthority {


    private String entity;
    private String entityCode;

    private String bscope;
    private String authority;

    public UAACustomAuthority(){
        this.setType("CUSTOM");
    }


    @Override
    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority=authority;
    }



}

