package cn.ibizlab.util.security;

import cn.ibizlab.util.helper.JacksonUtils;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;

@Data
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class AuthenticationUserImpl implements AuthenticationUser
{
	private static ObjectMapper objectMapper=new ObjectMapper();


	public AuthenticationUserImpl(){}
	/**
	 * 用戶标识
	 */
	private String userid;

	/**
	 * 用户全局名
	 */
	private String username;

	/**
	 * 用户姓名
	 */
	@JsonProperty("personname")
	@JSONField(name = "personname")
	private String personName;

	/**
	 * 用户显示名
	 */
	@Override
	public void setDisplayName(String displayName) {
		if(!ObjectUtils.isEmpty(displayName))
			setPersonName(displayName);
	}

	/**
	 * 登录名
	 */
	@JsonProperty("loginname")
	@JSONField(name = "loginname")
	private String loginName;

	/**
	 * 用户工号
	 */
	@JsonProperty("usercode")
	@JSONField(name = "usercode")
	private String userCode;

	/**
	 * 登录密码
	 */
	@JsonIgnore
	@JSONField(serialize = false)
	private String password;

	/**
	 * 区属
	 */
	private String domain;

	/**
	 * 单位标识
	 */
	@JsonProperty("orgid")
	@JSONField(name = "orgid")
	private String orgId;

	/**
	 * 单位编码
	 */
	@JsonProperty("orgcode")
	@JSONField(name = "orgcode")
	private String orgCode;

	/**
	 * 单位名称
	 */
	@JsonProperty("orgname")
	@JSONField(name = "orgname")
	private String orgName;

	/**
	 * 部门标识
	 */
	@JsonProperty("mdeptid")
	@JSONField(name = "mdeptid")
	private String mainDeptId;

	/**
	 * 部门编码
	 */
	@JsonProperty("mdeptcode")
	@JSONField(name = "mdeptcode")
	private String mainDeptCode;

	/**
	 * 部门名称
	 */
	@JsonProperty("mdeptname")
	@JSONField(name = "mdeptname")
	private String mainDeptName;

	/**
	 * 当前组标识
	 */
	@JsonProperty("curteamid")
	@JSONField(name = "curteamid")
	private String curTeamId;

	/**
	 * 业务编码
	 */
	@JsonProperty("bcode")
	@JSONField(name = "bcode")
	private String businessCode;

	/**
	 * 昵称别名
	 */
	@JsonProperty("nickname")
	@JSONField(name = "nickname")
	private String nickname;

	/**
	 * 邮箱
	 */
	private String email;

	/**
	 * 社交账号
	 */
	private String avatar;

	/**
	 * 电话
	 */
	private String phone;

	/**
	 * 照片
	 */
	@JsonProperty("usericon")
	@JSONField(name = "usericon")
	private String userIcon;

	/**
	 * 性别
	 */
	private String sex;

	/**
	 * 出生日期
	 */
	private Date birthday;

	/**
	 * 证件号码
	 */
	@JsonProperty("certcode")
	@JSONField(name = "certcode")
	private String certCode;

	/**
	 * 地址
	 */
	@JsonProperty("addr")
	@JSONField(name = "addr")
	private String address;

	/**
	 * 主题
	 */
	private String theme;

	/**
	 * 语言
	 */
	private String lang;

	/**
	 * 备注
	 */
	private String memo;

	/**
	 * 是否为超级管理员
	 */
	@JsonProperty("superuser")
	@JSONField(name = "superuser")
	private Integer superUser=0;

	@JsonIgnore
	@JSONField(serialize = false)
	public boolean isSuperUser() {
		return superUser==1;
	}

	/**
	 * 是否为接口用户
	 */
	@JsonProperty("apiuser")
	@JSONField(name = "apiuser")
	private Integer apiUser=0;

	@JsonIgnore
	@JSONField(serialize = false)
	public boolean isApiUser() {
		return apiUser==1;
	}


	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
	@JSONField(format="yyyy-MM-dd HH:mm:ss")
	private Date expiration;

	public String token;

	/**
	 * 用户权限资源
	 */
	@JsonIgnore
	@JSONField(serialize = false)
	private Collection<GrantedAuthority> authorities;

	/**
	 * 用户上下文参数
	 */
	@JsonIgnore
	@JSONField(serialize = false)
	private Map <String,Object> sessionParams;

	/**
	 * 用户上下文参数
	 */
	@JsonIgnore
	@JSONField(serialize = false)
	private Map<String,Object> extensionparams;;

    /**
    * 用户权限资源
    */
    private Map permissionList;


    /**
    * 当前用户上下级组织信息
    */
    private Map orgInfo;

	/**
	 * 所属组织
	 */
	@JsonIgnore
	@JSONField(serialize = false)
	private Set curOrgIds = new LinkedHashSet();

	public Set getCurOrgIds() {
		if(ObjectUtils.isEmpty(curOrgIds) && StringUtils.hasLength(orgId))
			curOrgIds.add(orgId);
		return curOrgIds;
	}

	/**
	* 上级组织
	*/
	@JsonIgnore
	@JSONField(serialize = false)
	private Set parentOrgIds = new LinkedHashSet();

	/**
	* 下级组织
	*/
	@JsonIgnore
	@JSONField(serialize = false)
	private Set subOrgIds = new LinkedHashSet();

	/**
	 * 所属部门
	 */
	@JsonIgnore
	@JSONField(serialize = false)
	private Set curDeptIds = new LinkedHashSet();

	public Set getCurDeptIds() {
		if(ObjectUtils.isEmpty(curDeptIds) && StringUtils.hasLength(mainDeptId))
			curDeptIds.add(mainDeptId);
		return curDeptIds;
	}

	/**
	* 上级部门
	*/
	@JsonIgnore
	@JSONField(serialize = false)
	private Set parentDeptIds = new LinkedHashSet();

	/**
	* 下级部门
	*/
	@JsonIgnore
	@JSONField(serialize = false)
	private Set subDeptIds = new LinkedHashSet();

	/**
	 * 所属组
	 */
	@JsonIgnore
	@JSONField(serialize = false)
	private Set curTeamIds = new LinkedHashSet();

	public Set getCurTeamIds() {
		if(ObjectUtils.isEmpty(curTeamIds) && StringUtils.hasLength(curTeamId))
			curTeamIds.add(curTeamId);
		return curTeamIds;
	}

	@JsonIgnore
	@JSONField(serialize = false)
    public Map getSessionParams()
    {
		if(this.sessionParams==null)
		{
			Hashtable all= JacksonUtils.toObj(this,Hashtable.class);
			all.remove("permissionList");
			all.remove("orgInfo");
			sessionParams = new HashMap<>();
			sessionParams.putAll(all);
			sessionParams.put("srfpersonid", this.getUserid());
			sessionParams.put("srfpersonname", this.getPersonName());
			sessionParams.put("srforgsectorid", this.getMainDeptId());
			sessionParams.put("srforgsectorcode", this.getMainDeptCode());
			sessionParams.put("srforgsectorname", this.getMainDeptName());
			sessionParams.put("srforgid", this.getOrgId());
			sessionParams.put("srforgcode", this.getOrgCode());
			sessionParams.put("srforgname", this.getOrgName());
			sessionParams.put("srfuserid", this.getUserid());
			sessionParams.put("srfusername", this.getPersonName());
			sessionParams.put("srfusermode", "");
			sessionParams.put("srforgsectorbc", this.getBusinessCode());
			sessionParams.put("srfloginname", this.getLoginName());
			sessionParams.put("srflocale", this.getLang());
			sessionParams.put("srftimezone", "");
    		sessionParams.put("srfusercode", this.getUserCode());
			sessionParams.put("srfcorg", getCond(getCurOrgIds()));
			sessionParams.put("srfporg", getCond(getParentOrgIds()));
			sessionParams.put("srfsorg", getCond(getSubOrgIds()));
			sessionParams.put("srfcdept", getCond(getCurDeptIds()));
			sessionParams.put("srfpdept", getCond(getParentDeptIds()));
			sessionParams.put("srfsdept", getCond(getSubDeptIds()));
			sessionParams.put("srfcteam", getCond(getCurTeamIds()));
			if(sessionParams.get("srfdcid")==null && sessionParams.get("tenant")!=null)
				sessionParams.put("srfdcid", sessionParams.get("tenant"));
			if(sessionParams.get("srfdcsystemid")==null && sessionParams.get("dcsystemid")!=null)
				sessionParams.put("srfdcsystemid", sessionParams.get("dcsystemid"));
		}
		return this.sessionParams;
    }

	@JsonIgnore
	@JSONField(serialize = false)
    public Map<String, Object> getExtensionparams() {
		if(extensionparams!=null){
			return extensionparams;
		}
		else{
			return new HashMap<>();
		}
    }

	public void setOrgInfo(Map orgInfo) {
		this.orgInfo = orgInfo;
		if(!ObjectUtils.isEmpty(orgInfo))
		{
			Object curorg=orgInfo.get("curorg");
			if(!ObjectUtils.isEmpty(curorg) && curorg instanceof Collection){
				getCurOrgIds().addAll((Collection)curorg);
			}
			Object parentorg=orgInfo.get("parentorg");
			if(!ObjectUtils.isEmpty(parentorg) && parentorg instanceof Collection){
				getParentOrgIds().addAll((Collection)parentorg);
			}
			Object suborg=orgInfo.get("suborg");
			if(!ObjectUtils.isEmpty(suborg) && suborg instanceof Collection){
				getSubOrgIds().addAll((Collection)suborg);
			}
			Object curdept=orgInfo.get("curdept");
			if(!ObjectUtils.isEmpty(curdept) && curdept instanceof Collection){
				getCurDeptIds().addAll((Collection)curdept);
			}
			Object parentdept=orgInfo.get("parentdept");
			if(!ObjectUtils.isEmpty(parentdept) && parentdept instanceof Collection){
				getParentDeptIds().addAll((Collection)parentdept);
			}
			Object subdept=orgInfo.get("subdept");
			if(!ObjectUtils.isEmpty(subdept) && subdept instanceof Collection){
				getSubDeptIds().addAll((Collection)subdept);
			}
			Object curteam=orgInfo.get("curteam");
			if(!ObjectUtils.isEmpty(curteam) && curteam instanceof Collection){
				getCurTeamIds().addAll((Collection)curteam);
			}
		}

	}

	private String getCond(Collection items) {
		return ObjectUtils.isEmpty(items)?null:"'"+String.join("','",items)+"'";
	}


	public void setPermissionList(Map permissionList) {
		this.permissionList = permissionList;
		if(authorities == null && permissionList !=null){
			if(permissionList.get("authorities")!=null){
				authorities=new ArrayList<>();
				((List)permissionList.get("authorities")).
						forEach(item->{
							if(item instanceof String)
								authorities.add(new SimpleGrantedAuthority(String.valueOf(item)));
							else if(item instanceof GrantedAuthority)
								authorities.add((GrantedAuthority)item);
							else
							{
								try {
									authorities.add(objectMapper.readValue(objectMapper.writeValueAsBytes(item), UAAGrantedAuthority.class));
								} catch (IOException e) {

								}
							}
						});
			}
		}
	}




	@JsonAnyGetter
	@JSONField(name = "_any", unwrapped = true, serialize = true, deserialize = false)
	public Map<String , Object> any() {
		return getExtensionparams();
	}



	@JsonAnySetter
	@JSONField(name = "_any", unwrapped = true, serialize = false, deserialize = true)
	public void set(String field, Object value) {
		this.getExtensionparams().put(field,value);
	}

	public Object get(String field) {
		return this.getExtensionparams().get(field);

	}

    protected List<AuthMember> memberOf;

    @Override
    public void setMemnerOf(List<AuthMember> memberOf) {
        this.memberOf = memberOf;
    }

    @Override
    public List<AuthMember> getMemberOf() {
        return this.memberOf;
    }

}
