package cn.ibizlab.util.security;

import cn.ibizlab.util.helper.JacksonUtils;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.*;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

public interface AuthenticationUser extends UserDetails
{
	default String getUserid() {
		return (String)get("userid|id|srfuserid|srfpersonid",getUsername());
	}

	default void setUserid(String userid) {put("userid",userid);};

	@Override
	default String getUsername() {
		return (String)get("username",String.join("|",getLoginName(),getDomain()));
	}

	default void setUsername(String username) {put("username",username);}

	default String getDisplayName() {
		return getPersonName();
	}

	default void setDisplayName(String displayName) {put("display_name",displayName);}

	default String getPersonName() {
		return (String)get("personname|display_name|srfpersonname|srfusername",getUsername());
	}

	default void setPersonName(String personName) {put("personname",personName);}

	default String getLoginName() {
		return (String)get("loginname|srfloginname","anonymousUser");
	}

	default void setLoginName(String loginName) {put("loginname",loginName);}

	default String getUserCode() {
		return (String)get("usercode|employee_number");
	}

	default void setUserCode(String userCode) {put("usercode",userCode);}

	default void setPassword(String password) {put("password",password);}

	default String getDomain() {
		return (String)get("domain|dc|srfdcid");
	}

	default void setDomain(String domain) {put("domain",domain);}

	default String getOrgId() {
		return (String)get("orgid|organization_id|srforgid");
	}

	default void setOrgId(String orgId) {put("orgid",orgId);}

	default String getOrgCode() {
		return (String)get("orgcode|organization_number|srforgcode");
	}

	default void setOrgCode(String orgCode) {put("orgcode",orgCode);}

	default String getOrgName() {
		return (String)get("orgname|organization_name|srforgname");
	}

	default void setOrgName(String orgName) {put("orgname",orgName);}

	default String getMainDeptId() {
		return (String)get("mdeptid|department_id|srforgsectorid");
	}

	default void setMainDeptId(String mainDeptId) {put("mdeptid",mainDeptId);}

	default String getMainDeptCode() {
		return (String)get("mdeptcode|department_number|srforgsectorcode");
	}

	default void setMainDeptCode(String mainDeptCode) {put("mdeptcode",mainDeptCode);}

	default String getMainDeptName() {
		return (String)get("mdeptname|department_name|srforgsectorname");
	}

	default void setMainDeptName(String mainDeptName) {put("mdeptname",mainDeptName);}

	default String getCurTeamId() {
		return (String)get("curteamid|organizational_role_id");
	}

	default void setCurTeamId(String curTeamId) {put("curteamid",curTeamId);}

	default String getDcSystemId() {
		return (String)get("srfdcsystemid|dcsystemid|deploy_system_id");
	}

	default void setDcSystemId(String dcSystemId) {put("srfdcsystemid",dcSystemId);}

	default String getSrfSystemId() {
		return (String)get("srfsystemid|systemid");
	}

	default void setSrfSystemId(String srfSystemId) {put("srfsystemid",srfSystemId);}

	default String getBusinessCode() {
		return (String)get("bcode|business_category|srforgsectorbc");
	}

	default void setBusinessCode(String businessCode) {put("bcode",businessCode);}

	default String getNickname() {
		return (String)get("nickname");
	}

	default void setNickname(String nickname) {put("nickname",nickname);}

	default String getEmail() {
		return (String)get("email|mail");
	}

	default void setEmail(String email) {put("email",email);}

	default String getAvatar() {
		return (String)get("avatar");
	}

	default void setAvatar(String avatar) {put("avatar",avatar);}

	default String getPhone() {
		return (String)get("phone|mobile|telephone_number");
	}

	default void setPhone(String phone) {put("phone",phone);}

	default String getUserIcon() {
		return (String)get("usericon");
	}

	default void setUserIcon(String userIcon) {put("usericon",userIcon);}

	default String getSex() {
		return (String)get("sex");
	}

	default void setSex(String sex) {put("sex",sex);}

	default Date getBirthday() {
		return (Date)get("birthday");
	}

	default void setBirthday(Date birthday) {put("birthday",birthday);}

	default String getCertCode() {
		return (String)get("certcode|identification_number");
	}

	default void setCertCode(String certCode) {put("certcode",certCode);}

	default String getAddress() {
		return (String)get("addr|postal_address");
	}

	default void setAddress(String address) {put("addr",address);}

	default String getTheme() {
		return (String)get("theme");
	}

	default void setTheme(String theme) {put("theme",theme);}

	default String getLang() {
		return (String)get("lang");
	}

	default void setLang(String lang) {put("lang",lang);}

	default String getMemo() {
		return (String)get("memo|description");
	}

	default void setMemo(String memo) {put("memo",memo);}

	@JsonIgnore
	@JSONField(serialize = false)
	default boolean isSuperUser() {
		return Integer.valueOf(1).equals(get("superuser"));
	}

	default void setSuperUser(Integer superUser) {put("superuser",superUser);}

	@JsonIgnore
	@JSONField(serialize = false)
	default boolean isApiUser() {
		return Integer.valueOf(1).equals(get("apiuser"));
	}

	default void setApiUser(Integer apiUser) {put("apiuser",apiUser);}

	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
	@JSONField(format="yyyy-MM-dd HH:mm:ss")
	default Date getExpiration() {
		return (Date)get("expiration");
	}

	default void setExpiration(Date expiration) {put("expiration",expiration);}

	default String getToken() {
		return (String)get("token");
	}

	default void setToken(String token) {put("token",token);}

	@JsonIgnore
	@JSONField(serialize = false)
	@Override
	default boolean isAccountNonExpired() {
		return getExpiration()==null?true:(!getExpiration().before(new Date()));
	}

	@JsonIgnore
	@JSONField(serialize = false)
	@Override
	default boolean isAccountNonLocked() {
		return true;
	};

	@JsonIgnore
	@JSONField(serialize = false)
	@Override
	default boolean isCredentialsNonExpired() {
		return true;
	}

	@JsonIgnore
	@JSONField(serialize = false)
	@Override
	default String getPassword() {
		return null;
	}

	@Override
	default boolean isEnabled() {
		return true;
	}

	@JsonIgnore
	@JSONField(serialize = false)
	default void setAuthorities(Collection<GrantedAuthority> authorities) {put("authorities",authorities);}

	@JsonIgnore
	@JSONField(serialize = false)
	Collection<GrantedAuthority> getAuthorities();

	@JsonIgnore
	@JSONField(serialize = false)
	Map<String, Object> getExtensionparams();

	@JsonIgnore
	@JSONField(serialize = false)
	default Map getSessionParams() {
		return getExtensionparams();
	}

	default Map getPermissionList() {
		return (Map)get("permissionList");
	}

	default void setPermissionList(Map permissionList) {put("permissionList",permissionList);}

	default Map getOrgInfo() {
		return (Map)get("orgInfo");
	}

	default void setOrgInfo(Map orgInfo) {put("orgInfo",orgInfo);}

	@JsonIgnore
	@JSONField(serialize = false)
	default Set getCurOrgIds() {
		String orgId=getOrgId();
		if(orgId!=null)
			return new HashSet(Arrays.asList(orgId));
		return new HashSet();
	}

	@JsonIgnore
	@JSONField(serialize = false)
	default Set getParentOrgIds() {
		return new HashSet();
	}

	@JsonIgnore
	@JSONField(serialize = false)
	default Set getSubOrgIds() {
		return getCurOrgIds();
	}

	@JsonIgnore
	@JSONField(serialize = false)
	default Set getCurDeptIds() {
		String deptId=getMainDeptId();
		if(deptId!=null)
			return new HashSet(Arrays.asList(deptId));
		return new HashSet();
	}

	@JsonIgnore
	@JSONField(serialize = false)
	default Set getParentDeptIds() {
		return new HashSet();
	}

	@JsonIgnore
	@JSONField(serialize = false)
	default Set getSubDeptIds() {
		return getCurDeptIds();
	}

	@JsonIgnore
	@JSONField(serialize = false)
	default Set getCurTeamIds() {
		String teamId=getCurTeamId();
		if(teamId!=null)
			return new HashSet(Arrays.asList(teamId));
		return new HashSet();
	}

	@JsonAnyGetter
	@JSONField(name = "_any", unwrapped = true, serialize = true, deserialize = false)
	default Map<String , Object> any() {return getExtensionparams();}

	@JsonAnySetter
	@JSONField(name = "_any", unwrapped = true, serialize = false, deserialize = true)
	default void set(String field, Object value) {
		if(getExtensionparams()!=null)
			getExtensionparams().put(field,value);
	}

	default void put(String field, Object value) {set(field,value);}

	default Object get(String field) {
		return get(field,null);
	}

	default Object get(String field,Object defaultValue) {
		if(any()!=null) {
			for(String key:field.split("[|]")) {
				Object obj=any().get(key);
				if(obj!=null)
					return obj;
			}
		}
		return defaultValue;
	}

	default void readHeader(boolean change) {}

	default void setMemnerOf(List<AuthMember> memberOf) {put("memberOf",memberOf);}
	default List<AuthMember> getMemberOf(){
		return (List)get("memberOf",new ArrayList<AuthMember>());
	}

	static AuthenticationUser getAuthenticationUser()
	{
		if(SecurityContextHolder.getContext()==null||SecurityContextHolder.getContext().getAuthentication()==null||SecurityContextHolder.getContext().getAuthentication().getPrincipal()==null){
			return new BaseImpl();
		}
		Object userDetails = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
		AuthenticationUser authuserdetail;
		if(userDetails instanceof AuthenticationUser) {
			authuserdetail= (AuthenticationUser)userDetails;
		}
		else if (userDetails instanceof String) {
			authuserdetail=new BaseImpl();
			authuserdetail.setUserid(userDetails.toString());
			authuserdetail.setUsername(userDetails.toString());
		}
		else {
			authuserdetail = BaseImpl.from(userDetails);
		}
		return authuserdetail;
	}

	static AuthenticationUser setAuthenticationUser(AuthenticationUser user) {
		UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(user, null, user.getAuthorities());
		SecurityContextHolder.getContext().setAuthentication(authentication);
		return user;
	}

	class BaseImpl implements AuthenticationUser {

		static ThreadLocal<AuthenticationUser> contextHolder = new ThreadLocal();

		synchronized static AuthenticationUser from(Object obj) {
			AuthenticationUser ctx = contextHolder.get();
			if (ctx == null) {
				ctx = JacksonUtils.toObj(JacksonUtils.toJson(obj),AuthUser20Impl.class);
				contextHolder.set(ctx);
			}
			return ctx;
		}

		@Override
		public String getLoginName() {
			return null;
		}

		@Override
		@JsonIgnore
		@JSONField(serialize = false)
		public Collection<GrantedAuthority> getAuthorities() {
			return null;
		}
		@JsonIgnore
		@JSONField(serialize = false)
		private Map extensionparams;

		@Override
		public Map getExtensionparams() {
			if(extensionparams==null) {
				extensionparams = new HashMap();
				ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
				if(requestAttributes!=null) {
					HttpServletRequest request = requestAttributes.getRequest();
					if (request != null) {
						Enumeration<String> headerNames = request.getHeaderNames();
						if (headerNames != null) {
							while (headerNames.hasMoreElements()) {
								String name = headerNames.nextElement();
								extensionparams.put(name,request.getHeader(name));
							}
						}
					}
				}
			}
			return extensionparams;
		}
	}

}
