package cn.ibizlab.util.security;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.annotation.Id;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.*;

@Getter
@Setter
@Slf4j
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@ApiModel(value = "AUTH_USER", description = "认证用户for UAA2.0")
public class AuthUser20Impl implements AuthenticationUser {


    /**
     * 标识
     */
    @Id
    @JsonProperty("id")
    @JSONField(name = "id")
    @ApiModelProperty(value = "id", notes = "标识")
    private String id;

    /**
     * 名称
     */
    @JsonProperty("display_name")
    @JSONField(name = "display_name")
    @ApiModelProperty(value = "display_name", notes = "名称")
    private String displayName;

    /**
     * username/uid
     */
    @JsonProperty("username")
    @JSONField(name = "username")
    @ApiModelProperty(value = "username", notes = "username/uid")
    private String username;

    /**
     * DC
     */
    @JsonProperty("dc")
    @JSONField(name = "dc")
    @ApiModelProperty(value = "dc", notes = "DC")
    private String dc;

    /**
     * 组织机构标识
     */
    @JsonProperty("organization_id")
    @JSONField(name = "organization_id")
    @ApiModelProperty(value = "organization_id", notes = "组织机构标识")
    private String organizationId;

    /**
     * 部门标识
     */
    @JsonProperty("department_id")
    @JSONField(name = "department_id")
    @ApiModelProperty(value = "department_id", notes = "部门标识")
    private String departmentId;

    /**
     * 用户组标识
     */
    @JsonProperty("organizational_role_id")
    @JSONField(name = "organizational_role_id")
    @ApiModelProperty(value = "organizational_role_id", notes = "用户组标识")
    private String organizationalRoleId;

    /**
     * 系统标识
     */
    @JsonProperty("deploy_system_id")
    @JSONField(name = "deploy_system_id")
    @ApiModelProperty(value = "deploy_system_id", notes = "系统标识")
    private String deploySystemId;

    /**
     * 系统名
     */
    @JsonProperty("system_id")
    @JSONField(name = "system_id")
    @ApiModelProperty(value = "system_id", notes = "系统名")
    private String systemId;

    /**
     * 人员编号
     */
    @JsonProperty("employee_number")
    @JSONField(name = "employee_number")
    @ApiModelProperty(value = "employee_number", notes = "人员编号")
    private String employeeNumber;

    /**
     * 类型
     */
    @JsonProperty("employee_type")
    @JSONField(name = "employee_type")
    @ApiModelProperty(value = "employee_type", notes = "类型")
    private String employeeType;

    /**
     * 职位
     */
    @JsonProperty("title")
    @JSONField(name = "title")
    @ApiModelProperty(value = "title", notes = "职位")
    private String title;

    /**
     * 电子邮箱
     */
    @JsonProperty("mail")
    @JSONField(name = "mail")
    @ApiModelProperty(value = "mail", notes = "电子邮箱")
    private String mail;

    /**
     * 联系电话
     */
    @JsonProperty("telephone_number")
    @JSONField(name = "telephone_number")
    @ApiModelProperty(value = "telephone_number", notes = "联系电话")
    private String telephoneNumber;

    /**
     * 移动电话
     */
    @JsonProperty("mobile")
    @JSONField(name = "mobile")
    @ApiModelProperty(value = "mobile", notes = "移动电话")
    private String mobile;

    /**
     * 证件号
     */
    @JsonProperty("identification_number")
    @JSONField(name = "identification_number")
    @ApiModelProperty(value = "identification_number", notes = "证件号")
    private String identificationNumber;

    /**
     * 地址
     */
    @JsonProperty("postal_address")
    @JSONField(name = "postal_address")
    @ApiModelProperty(value = "postal_address", notes = "地址")
    private String postalAddress;

    /**
     * 描述
     */
    @JsonProperty("description")
    @JSONField(name = "description")
    @ApiModelProperty(value = "description", notes = "描述")
    private String description;

    /**
     * 当前隶属于
     */
    @JsonProperty("cur_member_of")
    @JSONField(name = "cur_member_of")
    @ApiModelProperty(value = "cur_member_of", notes = "当前隶属于")
    private AuthMember curMemberOf;

    /**
     * 隶属于
     */
    @JsonProperty("member_of")
    @JSONField(name = "member_of")
    @ApiModelProperty(value = "member_of", notes = "隶属于")
    private List<AuthMember> memberOf;

    /**
     * 系统授权
     */
    @JsonProperty("roles")
    @JSONField(name = "roles")
    @ApiModelProperty(value = "roles", notes = "系统授权")
    private List<AuthGrantedSystem> roles;

    @JsonIgnore
    @JSONField(serialize = false)
    private String password;

    @JsonIgnore
    @JSONField(serialize = false)
    private LinkedHashSet<GrantedAuthority> authorities;

    @Override
    public String getUserid() {
        return getId();
    }

    @Override
    public String getLoginName() {
        return getUsername();
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public LinkedHashSet<GrantedAuthority> getAuthorities() {
        if(authorities == null && !ObjectUtils.isEmpty(this.getRoles())) {
            authorities = new LinkedHashSet<>();
            this.getRoles().forEach(system->{
                authorities.add(new SimpleGrantedAuthority(String.format("SYSTEM_%1$s",system.getDeploySystemId())));
                if(!ObjectUtils.isEmpty(system.getSystemId()))
                    authorities.add(new SimpleGrantedAuthority(String.format("SYSTEM_%1$s",system.getSystemId())));
                if(ObjectUtils.isEmpty(system.getRoles()))
                    return;
                system.getRoles().forEach(role->{
                    if(ObjectUtils.isEmpty(role.getAuthority()))
                        return;
                    if(role.getAuthority().equalsIgnoreCase("ROLE_SUPERADMIN"))
                        this.setSuperUser(1);
                    authorities.add(new SimpleGrantedAuthority(String.format("ROLE_%1$s",role.getRoleId())));
                    authorities.add(new SimpleGrantedAuthority(role.getAuthority()));
                    if(!ObjectUtils.isEmpty(system.getSystemId()))
                        authorities.add(new SimpleGrantedAuthority(String.format("ROLE_%1$s_%2$s",system.getSystemId(),role.getAuthority())));
                    if(!ObjectUtils.isEmpty(role.getAuthorities()))
                        role.getAuthorities().forEach(authGranted -> {
                            String authority = authGranted.getAuthority();
                            if(!ObjectUtils.isEmpty(authority)&&authority.indexOf(":")>0)
                                authority=authority.split(":")[1];
                            if(!ObjectUtils.isEmpty(authority)) {
                                String[] args=authority.split("-");
                                if(args.length==4&&args[2].startsWith("Fetch")) {
                                    args[2]=args[2].replace("Fetch","search");
                                    authority=String.join("-",args);
                                }
                                authorities.add(new SimpleGrantedAuthority(authority));
                            }
                        });
                });
            });
        }
        return authorities;
    }

    public void setId(String id) {
        this.id = id;
        this.setUserid(id);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.setPersonName(displayName);
    }

    public void setUsername(String username) {
        this.username = username;
        this.setLoginName(username);
    }

    public void setDc(String dc) {
        this.dc = dc;
        this.setDomain(dc);
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        this.setOrgId(organizationId);
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
        this.setMainDeptId(departmentId);
    }

    public void setOrganizationalRoleId(String organizationalRoleId) {
        this.organizationalRoleId = organizationalRoleId;
        this.setCurTeamId(organizationalRoleId);
    }

    public void setDeploySystemId(String deploySystemId) {
        this.deploySystemId = deploySystemId;
        this.setDcSystemId(deploySystemId);
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
        this.setSrfSystemId(systemId);
    }

    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
        this.setUserCode(employeeNumber);
    }

    public void setEmployeeType(String employeeType) {
        this.employeeType = employeeType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMail(String mail) {
        this.mail = mail;
        this.setEmail(mail);
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
        this.setPhone(mobile);
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
        this.setCertCode(identificationNumber);
    }

    public void setPostalAddress(String postalAddress) {
        this.postalAddress = postalAddress;
        this.setAddress(postalAddress);
    }

    public void setDescription(String description) {
        this.description = description;
        this.setMemo(description);
    }

    public void setMemberOf(List<AuthMember> memberOf) {
        this.memberOf = memberOf;
        if (!ObjectUtils.isEmpty(memberOf)) {
            changeOU(this.getOrganizationId(),this.getDepartmentId(),this.getOrganizationalRoleId());
        }
    }

    public void setCurMemberOf(AuthMember curMemberOf) {
        this.curMemberOf = curMemberOf;
        if(curMemberOf!=null) {
            this.setOrganizationId(curMemberOf.getOrganizationId());
            this.setOrgCode(curMemberOf.getOrganizationNumber());
            this.setOrgName(curMemberOf.getOrganizationName());
            this.setDepartmentId(curMemberOf.getDepartmentId());
            this.setMainDeptCode(curMemberOf.getDepartmentNumber());
            this.setMainDeptName(curMemberOf.getDepartmentName());
            this.setOrganizationalRoleId(curMemberOf.getOrganizationalRoleId());
            this.setDc(curMemberOf.getDc());

        }
    }

    public AuthUser20Impl changeOU(String organizationId, String departmentId, String organizationalRoleId) {
        if (!ObjectUtils.isEmpty(getMemberOf())){
            AuthMember member = getMemberOfByOrganizationalRoleId(organizationalRoleId);
            if(member==null) {
                member = getMemberOfByDepartmentId(departmentId);
                if(member==null) {
                    member = getMemberOfByOrganizationId(organizationId);
                }
            }
            if(member!=null)
                this.setCurMemberOf(member);
            else {
                this.setCurMemberOf(getMemberOf().get(0));
                log.warn("{}切换OU失败:o={},ou={},cn={}未找到memberOf.",this.getUsername(),organizationId,departmentId,organizationalRoleId);
            }
            this.sessionParams=null;
        }
        return this;
    }


    public AuthMember getMemberOfByOrganizationId(String organizationId) {
        if (!ObjectUtils.isEmpty(getMemberOf()) && !ObjectUtils.isEmpty(organizationId)){
            Optional<AuthMember> member = getMemberOf().stream().filter(item -> organizationId.equals(item.getOrganizationId())).findFirst();
            if(member.isPresent())
                return member.get();
        }
        return null;
    }

    public AuthMember getMemberOfByDepartmentId(String departmentId) {
        if (!ObjectUtils.isEmpty(getMemberOf()) && !ObjectUtils.isEmpty(departmentId)){
            Optional<AuthMember> member = getMemberOf().stream().filter(item -> departmentId.equals(item.getDepartmentId())).findFirst();
            if(member.isPresent())
                return member.get();
        }
        return null;
    }
    public AuthMember getMemberOfByOrganizationalRoleId(String organizationalRoleId) {
        if (!ObjectUtils.isEmpty(getMemberOf()) && !ObjectUtils.isEmpty(organizationalRoleId)){
            Optional<AuthMember> member = getMemberOf().stream().filter(item -> organizationalRoleId.equals(item.getOrganizationalRoleId())).findFirst();
            if(member.isPresent())
                return member.get();
        }
        return null;
    }

    @Override
    public Set getCurOrgIds() {
        if(getMemberOf()!=null)
            return new LinkedHashSet(memberOf.stream().filter(e->!ObjectUtils.isEmpty(e.getOrganizationId())).map(e -> e.getOrganizationId()).collect(java.util.stream.Collectors.toList()));
        return AuthenticationUser.super.getCurOrgIds();
    }

    @Override
    public Set getCurDeptIds() {
        if(getMemberOf()!=null)
            return new LinkedHashSet(memberOf.stream().filter(e->!ObjectUtils.isEmpty(e.getDepartmentId())).map(e -> e.getDepartmentId()).collect(java.util.stream.Collectors.toList()));
        return AuthenticationUser.super.getCurDeptIds();
    }

    @Override
    public Set getCurTeamIds() {
        if(getMemberOf()!=null)
            return new LinkedHashSet(memberOf.stream().filter(e->!ObjectUtils.isEmpty(e.getOrganizationalRoleId())).map(e -> e.getOrganizationalRoleId()).collect(java.util.stream.Collectors.toList()));
        return AuthenticationUser.super.getCurTeamIds();
    }

    public void setRoles(List<AuthGrantedSystem> roles) {
        this.roles = roles;
        changeSystem(this.getDeploySystemId(),this.getSystemId());
    }

    public AuthUser20Impl changeSystem(String deploySystemId, String systemId) {
        if(!ObjectUtils.isEmpty(getRoles())) {
            AuthGrantedSystem system=getSystemByDeploySystemId(deploySystemId);
            if(system==null)
                system = getSystemBySystemId(systemId);
            if(system==null)
                system = getRoles().get(0);
            this.setDeploySystemId(system.getDeploySystemId());
            this.setSystemId(system.getSystemId());
            this.sessionParams=null;
        }
        return this;
    }

    public AuthGrantedSystem getSystemByDeploySystemId(String deploySystemId) {
        if (!ObjectUtils.isEmpty(getRoles()) && !ObjectUtils.isEmpty(deploySystemId)){
            Optional<AuthGrantedSystem> system = getRoles().stream().filter(item -> deploySystemId.equals(item.getDeploySystemId())).findFirst();
            if(system.isPresent())
                return system.get();
        }
        return null;
    }

    public AuthGrantedSystem getSystemBySystemId(String systemId) {
        if (!ObjectUtils.isEmpty(getRoles()) && !ObjectUtils.isEmpty(systemId)){
            Optional<AuthGrantedSystem> system = getRoles().stream().filter(item -> systemId.equals(item.getSystemId())).findFirst();
            if(system.isPresent())
                return system.get();
        }
        return null;
    }

    public void readHeader(boolean change) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if(requestAttributes!=null) {
            HttpServletRequest request = requestAttributes.getRequest();
            if (request != null) {
                if(change) {
                    Enumeration<String> headerNames = request.getHeaderNames();
                    if (headerNames != null) {
                        while (headerNames.hasMoreElements()) {
                            String name = headerNames.nextElement();
                            if (name.startsWith("srf"))
                                getExtensionparams().put(name, request.getHeader(name));
                        }
                    }
                }
                String srforgid=request.getHeader("srforgid");
                if ("undefined".equals(srforgid))
                    srforgid=null;
                String srforgsectorid=request.getHeader("srforgsectorid");
                if ("undefined".equals(srforgsectorid))
                    srforgsectorid=null;
                String srfdcsystemid=request.getHeader("srfdcsystemid");
                if ("undefined".equals(srfdcsystemid))
                    srfdcsystemid=null;
                String srfsystemid=request.getHeader("srfsystemid");
                if ("undefined".equals(srfsystemid))
                    srfsystemid=null;
                if((!ObjectUtils.isEmpty(srforgid) && !srforgid.equals(this.getOrganizationId())) ||
                        (!ObjectUtils.isEmpty(srforgid) && !srforgid.equals(this.getOrgId())) ||
                        (!ObjectUtils.isEmpty(srforgsectorid) && !srforgsectorid.equals(this.getDepartmentId())) ||
                        (!ObjectUtils.isEmpty(srforgsectorid) && !srforgsectorid.equals(this.getMainDeptId())) )
                    changeOU(srforgid,srforgsectorid,null);
                if((!ObjectUtils.isEmpty(srfdcsystemid) && !srfdcsystemid.equals(this.getDeploySystemId())) ||
                        (!ObjectUtils.isEmpty(srfdcsystemid) && !srfdcsystemid.equals(this.getDcSystemId())) ||
                        (!ObjectUtils.isEmpty(srfsystemid) && !srfsystemid.equals(this.getSystemId())) )
                    changeSystem(srfdcsystemid,srfsystemid);
            }
        }
    }

    @JsonIgnore
    @JSONField(serialize = false)
    private Map<String,Object> extensionparams;

    @JsonIgnore
    @JSONField(serialize = false)
    public Map<String, Object> getExtensionparams() {
        if(extensionparams==null){
            extensionparams = new HashMap<>();
        }
        return extensionparams;
    }

    @JsonIgnore
    @JSONField(serialize = false)
    private Map <String,Object> sessionParams;

    @JsonIgnore
    @JSONField(serialize = false)
    public Map getSessionParams()
    {
        if(this.sessionParams==null)
        {
            sessionParams = new HashMap<>();
            sessionParams.putAll(getExtensionparams());
            sessionParams.put("srfpersonid", this.getUserid());
            sessionParams.put("srfpersonname", this.getPersonName());
            sessionParams.put("srforgsectorid", this.getMainDeptId());
            sessionParams.put("srforgsectorcode", this.getMainDeptCode());
            sessionParams.put("srforgsectorname", this.getMainDeptName());
            sessionParams.put("srfteamid", this.getCurTeamId());
            sessionParams.put("srforgid", this.getOrgId());
            sessionParams.put("srforgcode", this.getOrgCode());
            sessionParams.put("srforgname", this.getOrgName());
            sessionParams.put("srfuserid", this.getUserid());
            sessionParams.put("srfusername", this.getPersonName());
            sessionParams.put("srfusermode", "");
            sessionParams.put("srforgsectorbc", this.getBusinessCode());
            sessionParams.put("srfloginname", this.getLoginName());
            sessionParams.put("srflocale", this.getLang());
            sessionParams.put("srftimezone", "");
            sessionParams.put("srfusercode", this.getUserCode());
            sessionParams.put("srfcorg", getCond(getCurOrgIds()));
            sessionParams.put("srfporg", getCond(getParentOrgIds()));
            sessionParams.put("srfsorg", getCond(getSubOrgIds()));
            sessionParams.put("srfcdept", getCond(getCurDeptIds()));
            sessionParams.put("srfpdept", getCond(getParentDeptIds()));
            sessionParams.put("srfsdept", getCond(getSubDeptIds()));
            sessionParams.put("srfcteam", getCond(getCurTeamIds()));
            if(sessionParams.get("srfdcid")==null && sessionParams.get("tenant")!=null)
                sessionParams.put("srfdcid", sessionParams.get("tenant"));
            if(sessionParams.get("srfdcsystemid")==null && this.getDeploySystemId()!=null)
                sessionParams.put("srfdcsystemid", this.getDeploySystemId());
            if(sessionParams.get("srfsystemid")==null && this.getSystemId()!=null)
                sessionParams.put("srfsystemid", this.getSystemId());
            sessionParams.put("member_of",getMemberOf());
            sessionParams.put("roles",getRoles());
        }
        return this.sessionParams;
    }

    private String getCond(Collection items) {
        return ObjectUtils.isEmpty(items)?null:"'"+String.join("','",items)+"'";
    }


    @Getter
    @Setter
    @NoArgsConstructor
    @Accessors(chain = true)
    @JsonIgnoreProperties(value = "handler")
    @ApiModel(value = "AUTH_GRANTED_SYSTEM", description = "授权系统")
    public static class AuthGrantedSystem implements Serializable
    {

        /**
         * 系统标识
         */
        @Id
        @JsonProperty("deploy_system_id")
        @JSONField(name = "deploy_system_id")
        @ApiModelProperty(value = "deploy_system_id", notes = "系统标识")
        private String deploySystemId;

        /**
         * 系统名称
         */
        @JsonProperty("display_name")
        @JSONField(name = "display_name")
        @ApiModelProperty(value = "display_name", notes = "系统名称")
        private String displayName;

        /**
         * 系统名
         */
        @JsonProperty("system_id")
        @JSONField(name = "system_id")
        @ApiModelProperty(value = "system_id", notes = "系统名")
        private String systemId;

        /**
         * 角色
         */
        @JsonProperty("roles")
        @JSONField(name = "roles")
        @ApiModelProperty(value = "roles", notes = "角色")
        private List<AuthGrantedRole> roles;

    }


    @Getter
    @Setter
    @NoArgsConstructor
    @Accessors(chain = true)
    @JsonIgnoreProperties(value = "handler")
    @ApiModel(value = "AUTH_GRANTED_ROLE", description = "授权角色")
    public static class AuthGrantedRole implements Serializable
    {

        /**
         * 角色标识
         */
        @Id
        @JsonProperty("role_id")
        @JSONField(name = "role_id")
        @ApiModelProperty(value = "role_id", notes = "角色标识")
        private String roleId;

        /**
         * 角色名
         */
        @JsonProperty("display_name")
        @JSONField(name = "display_name")
        @ApiModelProperty(value = "display_name", notes = "角色名")
        private String displayName;

        /**
         * 角色代码标记
         */
        @JsonProperty("authority")
        @JSONField(name = "authority")
        @ApiModelProperty(value = "authority", notes = "角色代码标记")
        private String authority;

        /**
         * 授权清单
         */
        @JsonProperty("authorities")
        @JSONField(name = "authorities")
        @ApiModelProperty(value = "authorities", notes = "授权清单")
        private List<AuthGranted> authorities;




    }


    @Getter
    @Setter
    @NoArgsConstructor
    @Accessors(chain = true)
    @JsonIgnoreProperties(value = "handler")
    @ApiModel(value = "AUTH_GRANTED", description = "授权对象")
    public static class AuthGranted implements Serializable
    {

        /**
         * 资源符
         */
        @Id
        @JsonProperty("authority")
        @JSONField(name = "authority")
        @ApiModelProperty(value = "authority", notes = "资源符")
        private String authority;

        /**
         * 权限类型
         */
        @JsonProperty("permission_type")
        @JSONField(name = "permission_type")
        @ApiModelProperty(value = "permission_type", notes = "权限类型")
        private String permissionType;

        /**
         * 显示名
         */
        @JsonProperty("display_name")
        @JSONField(name = "display_name")
        @ApiModelProperty(value = "display_name", notes = "显示名")
        private String displayName;


    }

}
