/**
 * Generate code from /{{projectName}}-core/src/main/java/{{packageName}}/core/{{modules}}/domain/{{entities@NONE}}.java.hbs
 */
package cn.ibizlab.util.security;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;

import java.io.Serializable;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(value = "handler")
@ApiModel(value = "AUTH_MEMBER", description = "隶属信息")
public class AuthMember implements Serializable
{

    /**
     * 用户组标识
     */
    @Id
    @JsonProperty("organizational_role_id")
    @JSONField(name = "organizational_role_id")
    @ApiModelProperty(value = "organizational_role_id", notes = "用户组标识")
    private String organizationalRoleId;

    /**
     * 用户组名称
     */
    @JsonProperty("organizational_role_name")
    @JSONField(name = "organizational_role_name")
    @ApiModelProperty(value = "organizational_role_name", notes = "用户组名称")
    private String organizationalRoleName;

    /**
     * 部门标识
     */
    @JsonProperty("department_id")
    @JSONField(name = "department_id")
    @ApiModelProperty(value = "department_id", notes = "部门标识")
    private String departmentId;

    /**
     * 部门编号
     */
    @JsonProperty("department_number")
    @JSONField(name = "department_number")
    @ApiModelProperty(value = "department_number", notes = "部门编号")
    private String departmentNumber;

    /**
     * 部门名称
     */
    @JsonProperty("department_name")
    @JSONField(name = "department_name")
    @ApiModelProperty(value = "department_name", notes = "部门名称")
    private String departmentName;

    /**
     * 组织机构标识
     */
    @JsonProperty("organization_id")
    @JSONField(name = "organization_id")
    @ApiModelProperty(value = "organization_id", notes = "组织机构标识")
    private String organizationId;

    /**
     * 机构编号
     */
    @JsonProperty("organization_number")
    @JSONField(name = "organization_number")
    @ApiModelProperty(value = "organization_number", notes = "机构编号")
    private String organizationNumber;

    /**
     * 组织机构名称
     */
    @JsonProperty("organization_name")
    @JSONField(name = "organization_name")
    @ApiModelProperty(value = "organization_name", notes = "组织机构名称")
    private String organizationName;

    /**
     * DC
     */
    @JsonProperty("dc")
    @JSONField(name = "dc")
    @ApiModelProperty(value = "dc", notes = "DC")
    private String dc;


}