package cn.ibizlab.util.rest;

import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.service.AuthenticationUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.*;

@RestController
@RequestMapping(value = "/")
public class AppController {

	@Autowired
	private AuthenticationUserService userDetailsService;

	@RequestMapping(method = {RequestMethod.GET,RequestMethod.POST}, value = "appdata")
	public ResponseEntity getAppData() {
		return ResponseEntity.status(HttpStatus.OK).body(userDetailsService.getAppData());
	}

    @RequestMapping(method = {RequestMethod.GET,RequestMethod.POST}, value = "${ibiz.auth.logoutpath:v7/logout}")
    public void logout() {
		if(AuthenticationUser.getAuthenticationUser()!=null){
			userDetailsService.resetByUsername(AuthenticationUser.getAuthenticationUser().getUsername());
    	}
    }

}
