package cn.ibizlab.util.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.ObjectUtils;

import java.io.IOException;
import java.io.StringReader;
import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class Setting {
    private String property;
    private String value;


    public static String getValue(String configString,String propertyName)
    {
        return DataObject.getStringValue(getMap(configString).get(propertyName),"");
    }


    public static Map<String,Object> getMap(String configString)
    {
        Map<String,Object> map=new LinkedHashMap<>();
        if(!(ObjectUtils.isEmpty(configString)))
        {
            map.put("param",configString);
            try
            {
                JSONValidator validator=JSONValidator.from(configString);
                if(JSONValidator.Type.Array.equals(validator.getType()))
                {
                    List<Setting> settings= JSONArray.parseArray(configString,Setting.class);
                    for(Setting setting:settings)
                        map.put(setting.getProperty(),DynamicParamUtils.process(setting.getValue()));
                }
                else if(JSONValidator.Type.Object.equals(validator.getType()))
                {
                    JSONObject.parseObject(configString).entrySet().forEach(entry->{
                        map.put(entry.getKey(),DynamicParamUtils.processObject(entry.getValue()));
                    });
                }
                else if(configString.indexOf(": ")>0)
                {
                    Map<String,Object> newMap=JacksonUtils.ymlToObj(configString,LinkedHashMap.class);
                    if(!ObjectUtils.isEmpty(newMap))
                    {
                        newMap.entrySet().forEach(entry->{
                            map.put(entry.getKey(),DynamicParamUtils.processObject(entry.getValue()));
                        });
                    }
                }
                else if(configString.indexOf("=")>0)
                {
                    Properties proper = new Properties();
                    try {
                        proper.load(new StringReader(configString)); //把字符串转为reader
                    } catch (IOException e) {
                    }
                    Enumeration enum1 = proper.propertyNames();
                    while (enum1.hasMoreElements()) {
                        String strKey = (String) enum1.nextElement();
                        String strValue = proper.getProperty(strKey);
                        map.put(strKey, DynamicParamUtils.process(strValue));
                    }
                }

            }
            catch (Exception ex)
            {

            }
        }
        return map;
    }


}
