package cn.ibizlab.util.client;

import cn.ibizlab.util.security.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@FeignClient(value = "${ibiz.ref.service.uaa:uaa-api}",contextId = "uaa20",url = "${ibiz.ref.service.rt.url:}")
public interface UaaFeignClient {

    @PostMapping(value = "/sys_deploy_systems/save",consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseEntity<String> deploySystem(@RequestHeader Map<String, Object> headers, @RequestBody String requestBody);

    @PostMapping("/auths/login")
    AuthenticationInfo<AuthUser20Impl> login(@RequestHeader("Authorization") String token,@RequestBody AuthorizationLogin authorizationLogin);

    default AuthenticationInfo<AuthUser20Impl> login(AuthorizationLogin authorizationLogin) {
        return login("NONE",authorizationLogin);
    }

    @PostMapping(value = "/auths/{username}/logout")
    Boolean uaaLogout(@RequestHeader("Authorization") String token, @PathVariable("username") String username);

    default Boolean uaaLogout(String username) {
        return uaaLogout("NONE",username);
    }

    /**
     * 查询授权用户信息
     */
    @PostMapping("/auth_users/{username}/loaduserbyusername")
    AuthUser20Impl loadUserByUsername(@PathVariable("username") String username);

}
