package cn.ibizlab.util.client;

import cn.ibizlab.util.dict.Catalog;
import cn.ibizlab.util.dict.CodeList;
import com.alibaba.fastjson.JSONArray;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${ibiz.ref.service.dict:ibzdict-api}",contextId = "dict",fallback = IBZDictFallback.class)
public interface IBZDictFeignClient
{
	@RequestMapping(method = RequestMethod.POST, value = "/dictionarys/catalogs/sync")
	Boolean syncRuntimeDict(@RequestBody JSONArray catalogs);

	@Cacheable( value="dictcatalog",key = "'codelist:'+#p0")
	@RequestMapping(method = RequestMethod.GET, value = "/dictionarys/codelist/{code}")
    CodeList getCodeList(@PathVariable("code") String code);

	@Cacheable( value="dictcatalog",key = "'dict:'+#p0")
	@RequestMapping(method = RequestMethod.GET, value = "/dictionarys/catalogs/{code}")
    Catalog getCatalog(@PathVariable("code") String code);

}