package cn.ibizlab.util.cache.redis;

import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class CustomJacksonSerializer<T> extends Jackson2JsonRedisSerializer<T>  {

    public static final String CLASSNAME_EX="_$$_";

    public static final String CLASSNAME_EX_PATTEN="(_\\$\\$_)(\\w+)";

    public CustomJacksonSerializer(Class type) {
        super(type);
    }

    /**
     * 对象反序列化处理：去除将实体类代理对象的className后缀
     * @param bytes
     * @return
     * @throws SerializationException
     */
    @Override
    public T deserialize(byte[] bytes) throws SerializationException {
        String serializerContent = new String(bytes, DEFAULT_CHARSET);
        if (serializerContent.contains(CLASSNAME_EX)) {
            serializerContent = serializerContent.replaceAll(CLASSNAME_EX_PATTEN, "");
        }
        return super.deserialize(serializerContent.getBytes());
    }
}
