package cn.ibizlab.util.service;

import cn.ibizlab.util.security.AuthTokenUtil;
import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Primary;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.stereotype.Service;

/**
 * 实体[IBZUSER] 服务对象接口实现
 */
@Primary
@Service("SimpleUserService")
@ConditionalOnExpression("(!${ibiz.enablePermissionValid:false})&&'${ibiz.auth.service:IBZUAAUserService}'.equals('SimpleUserService')")
public class SimpleUserService implements AuthenticationUserService {


	@Value("${ibiz.enablePermissionValid:false}")
	boolean enablePermissionValid;  //是否开启权限校验

	@Value("${ibiz.systemid}")
	private String systemId;

	@Override
	public boolean isEnablePermissionValid() {
		return enablePermissionValid;
	}

	@Override
	public String getSystemId() {
		return systemId;
	}
	@Override
	@Cacheable( value="ibzuaa_users", key = "#root.target.systemId+':getByUsername:'+#p0")
	public AuthenticationUser loadUserByUsername(String username) {
		AuthenticationUser user = new AuthenticationUser();
		String[] data = username.split("[|]");
		String loginname = username;
		String domains = "";
		String password = "";

		if(data.length==2) {
			loginname = data[0].trim();
			domains = data[1].trim();
		}

		user.setUserid(username);
		user.setUsercode(loginname);
		user.setUsername(username);
		user.setLoginname(loginname);
		user.setPersonname(loginname);
		user.setDomain(domains);
		user.setPassword(password);
		user.setOrgid(domains);
		user.setOrgcode(domains);
		user.setOrgname(domains);
		user.setSuperuser(1);
		user.setAuthorities(AuthorityUtils.createAuthorityList("ROLE_SUPERADMIN"));

		return user;
	}


	@Autowired
	private AuthTokenUtil jwtTokenUtil;

	@Override
	public AuthenticationInfo loadUserByLogin(String username, String password) {
		AuthenticationUser authuserdetail = loadUserByUsername(username);
		final String token = jwtTokenUtil.generateToken(authuserdetail);
		// 返回 token
		return new AuthenticationInfo(token,authuserdetail);
	}



	@Override
	@CacheEvict( value="ibzuaa_users", key = "'glob:*getByUsername:'+#p0")
	public void resetByUsername(String username) {

	}

}
