package cn.ibizlab.util.service;


import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.util.ObjectUtils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;


public interface AuthenticationUserService extends UserDetailsService {


    @Override
    default AuthenticationUser loadUserByUsername(String username){
        return null ;
    }


    //@Cacheable( value="ibzuaa_users", key = "'getByUsername:'+#p0")
    AuthenticationInfo loadUserByLogin(String username, String password);


    default void resetByUsername(String username){}

    boolean isEnablePermissionValid();  //是否开启权限校验


    String getSystemId();

    default Map getAppData()
    {

        Map appData = new HashMap() ;
        Set<String> appMenu = new HashSet();
        Set<String> uniRes = new HashSet();

        AuthenticationUser curUser = AuthenticationUser.getAuthenticationUser();
        if(isEnablePermissionValid()&&(!ObjectUtils.isEmpty(getSystemId()))){
            Collection<GrantedAuthority> authorities=curUser.getAuthorities();
            Iterator it = authorities.iterator();
            while(it.hasNext()) {
                GrantedAuthority authority = (GrantedAuthority)it.next();
                String strAuthority=authority.getAuthority();
                if(strAuthority.startsWith("UNIRES_"+getSystemId())) {
                    uniRes.add(strAuthority.substring(getSystemId().length()+8));
                }
                else if(strAuthority.startsWith("APPMENU_"+getSystemId())){
                    appMenu.add(strAuthority.substring(getSystemId().length()+9));
                }
            }
        }
        if (!ObjectUtils.isEmpty(curUser.getExpiration())) {
            // yyyy-MM-dd HH:mm:ss
            DateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            appData.put("expireddate", dtFormat.format(curUser.getExpiration()));
        }
        Map<String,Object> context = new HashMap<>();
        context.putAll(curUser.getSessionParams());
        context.put("srfusername",curUser.getPersonname());
        appData.put("context",context);
        appData.put("unires",uniRes);
        appData.put("appmenu",appMenu);
        appData.put("enablepermissionvalid",isEnablePermissionValid());
        if(curUser.getSuperuser()==1){
            appData.put("enablepermissionvalid",false);
        }
        else{
            appData.put("enablepermissionvalid",isEnablePermissionValid());
        }
        fillAppData(appData);
        return appData;
    }

    default void fillAppData(Map appData) {}

}
