package cn.ibizlab.util.security;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;
import org.springframework.security.core.GrantedAuthority;


@Data
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.PROPERTY,
        property = "type")
@JsonSubTypes({
        @JsonSubTypes.Type(value = UAADEAuthority.class, name= UAAGrantedAuthority.TYPE_OPPRIV),
        @JsonSubTypes.Type(value = UAAMenuAuthority.class, name= UAAGrantedAuthority.TYPE_APPMENU),
        @JsonSubTypes.Type(value = UAAUniResAuthority.class, name= UAAGrantedAuthority.TYPE_UNIRES),
        @JsonSubTypes.Type(value = UAARoleAuthority.class, name= UAAGrantedAuthority.TYPE_ROLE),
        @JsonSubTypes.Type(value = UAACustomAuthority.class, name= UAAGrantedAuthority.TYPE_CUSTOM)
})

public class UAAGrantedAuthority implements GrantedAuthority {

    public final static String TYPE_CUSTOM = "CUSTOM";

    public final static String TYPE_OPPRIV = "OPPRIV";

    public final static String TYPE_UNIRES = "UNIRES";

    public final static String TYPE_APPMENU = "APPMENU";

    public final static String TYPE_ROLE = "ROLE";

    private String name;
    private String type ;
    private String systemid;

    @Override
    public String getAuthority() {
        return null;
    }

}

