package cn.ibizlab.util.security;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import org.springframework.util.ObjectUtils;

import java.util.*;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class UAADEAuthority extends UAAGrantedAuthority {


    private String entity;
    private String entityCode;
    private Integer enableorgdr;
    private Integer enabledeptdr;
    private Integer enabledeptbc;
    private Integer orgdr;
    private Integer deptdr;
    private String deptbc;
    private String systemid;
    private Integer isAllData;
    private boolean dataset;
    private String bscope;
    private String authority;
    private List<Map<String, String>> deAction = new ArrayList<>();

    public UAADEAuthority(){
        this.setType("OPPRIV");
    }


    @Override
    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority=authority;
    }

    public Set<String> getAuthorities()
    {
        Set<String> sets=new LinkedHashSet<>();
        if(ObjectUtils.isEmpty(entityCode))
            return sets;
        if(ObjectUtils.isEmpty(systemid))
            return sets;

        Set<String> scopes=new LinkedHashSet<>();
        if(1==isAllData)
            scopes.add("all");
        else if(orgdr!=null&&(1&orgdr)>0)
            scopes.add("curorg");
        else if(orgdr!=null&&(2&orgdr)>0)
            scopes.add("porg");
        else if(orgdr!=null&&(4&orgdr)>0)
            scopes.add("sorg");
        else if(deptdr!=null&&(1&deptdr)>0)
            scopes.add("curorgdept");
        else if(deptdr!=null&&(2&deptdr)>0)
            scopes.add("porgdept");
        else if(deptdr!=null&&(4&deptdr)>0)
            scopes.add("sorgdept");
        else if(getName()!=null&&getName().startsWith("当前用户"))
            scopes.add("createman");
        else if(dataset||(!ObjectUtils.isEmpty(bscope)))
            scopes.add("custom");

        Set<String> privs=new LinkedHashSet<>();
        deAction.forEach(item->{
            String scope="";
            if(item.containsKey("READ"))
                privs.add("Get");
            else if(item.containsKey("CREATE")) {
                privs.add("Create");
                privs.add("Save");
            }
            else if(item.containsKey("Update")) {
                privs.add("Create");
                privs.add("Save");
            }
            else if(item.containsKey("DELETE"))
                privs.add("Remove");
            else
            {
                privs.addAll(item.keySet());
            }

        });

        scopes.forEach(scope->{
            privs.forEach(priv->{
                sets.add(String.format("%s-%s-%s-%s",systemid,entityCode,priv,scope));
            });
        });

        return sets;
    }



}

