/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.web;

import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.filter.SearchContextBase;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.QueryMapEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.openfeign.support.PageableSpringQueryMapEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Configuration
public class SearchContextHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(SearchContextHandlerMethodArgumentResolver.class);
    @Value(value="${ibiz.pageLimit:1000}")
    private int pageLimit = 1000;
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Bean
    @ConditionalOnMissingBean
    public QueryMapEncoder feignQueryMapEncoderPageable() {
        return new SearchContexSpringQueryMapEncoder();
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return SearchContextBase.class.isAssignableFrom(parameter.getParameterType()) || DTOBase.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Map params = webRequest.getParameterMap();
        LinkedHashMap<String, Object> set = new LinkedHashMap<String, Object>();
        for (String key : params.keySet()) {
            set.put(key, ((String[])params.get(key))[0]);
        }
        if (SearchContextBase.class.isAssignableFrom(parameter.getParameterType()) && !set.containsKey("size")) {
            set.put("size", this.pageLimit);
        }
        String json = objectMapper.writeValueAsString(set);
        return objectMapper.readValue(json, parameter.getParameterType());
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public class SearchContexSpringQueryMapEncoder
    extends PageableSpringQueryMapEncoder {
        public Map<String, Object> encode(Object object) {
            if (this.supports(object)) {
                try {
                    return (Map)objectMapper.readValue(objectMapper.writeValueAsString(object), HashMap.class);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            return super.encode(object);
        }

        protected boolean supports(Object object) {
            return object != null && (object instanceof SearchContextBase || object instanceof DTOBase);
        }
    }
}

