/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.tenant;

import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.tenant.TenantProperties;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@EnableConfigurationProperties(value={TenantProperties.class})
@ConditionalOnExpression(value="'${ibiz.tenant.enabled:false}'.equals('true')")
public class TenantHandler
implements TenantLineHandler {
    @Autowired
    private TenantProperties tenantProperties;

    public Expression getTenantId() {
        String tenantId = AuthenticationUser.getAuthenticationUser().getDc();
        if (ObjectUtils.isEmpty((Object)tenantId)) {
            return null;
        }
        return new StringValue(tenantId);
    }

    public String getTenantIdColumn() {
        return this.tenantProperties.getTenantIdColumn();
    }

    public boolean ignoreTable(String tableName) {
        return this.tenantProperties.getIgnoreTables().stream().anyMatch(table -> table.equalsIgnoreCase(tableName));
    }
}

