/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.tenant;

import cn.ibizlab.util.tenant.TenantProperties;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
@ConditionalOnExpression(value="'${ibiz.tenant.enabled:false}'.equals('true')")
public class TenantFeignInterceptor
implements RequestInterceptor {
    @Autowired
    private TenantProperties tenantProperties;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes != null && requestAttributes.getRequest() != null || ObjectUtils.isEmpty((Object)this.tenantProperties.getTenantId()))) {
            requestTemplate.header(this.tenantProperties.getTenantHeader(), new String[]{this.tenantProperties.getTenantId()});
            this.logger.info("tenant feign interceptor header:{}", (Object)requestTemplate);
        }
    }
}

