/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.tenant;

import cn.ibizlab.util.db.dialect.MySqlDialect;
import cn.ibizlab.util.tenant.TenantHandler;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="'${ibiz.tenant.enabled:false}'.equals('true')")
public class TenantConfiguration {
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor(DataSource dataSource, TenantHandler tenantHandler) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new TenantLineInnerInterceptor((TenantLineHandler)tenantHandler));
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor();
        this.initDialect(dataSource, paginationInnerInterceptor);
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
        return interceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDialect(DataSource dataSource, PaginationInnerInterceptor paginationInnerInterceptor) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DbType dbType = JdbcUtils.getDbType((String)connection.getMetaData().getURL());
            if (dbType == DbType.MYSQL) {
                Properties properties = new Properties();
                properties.put("dialect", MySqlDialect.class.getCanonicalName());
                paginationInnerInterceptor.setProperties(properties);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }
}

