/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.domain.AuditItem;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.domain.LoggingEvent;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.mapper.LoggingEventMapper;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.service.IBZDataAuditService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SimpleAuditService
implements IBZDataAuditService {
    private static final Logger log = LoggerFactory.getLogger(SimpleAuditService.class);
    private static SimpleAuditService instance = null;
    private static List<LoggingEvent> cacheMap = Collections.synchronizedList(new ArrayList());
    @Autowired
    private LoggingEventMapper loggingEventMapper;
    private Boolean save2db;

    public static SimpleAuditService getInstance() {
        return instance;
    }

    @PostConstruct
    private void init() {
        instance = this;
    }

    @Scheduled(fixedRate=10000L)
    private void saveAudit() {
        if (cacheMap.size() > 0) {
            log.info(String.format("\u6b63\u5728\u4fdd\u5b58\u5ba1\u8ba1\u6570\u636e\uff0c\u5f53\u524d\u5ba1\u8ba1\u96c6\u5408\u6570\u91cf\u4e3a[%s]", cacheMap.size()));
            ArrayList<LoggingEvent> temp = new ArrayList<LoggingEvent>();
            if (cacheMap.size() < 500) {
                temp.addAll(cacheMap);
            } else {
                temp.addAll(cacheMap.subList(0, 500));
            }
            temp.forEach(item -> log.debug("Audit:{}-{}:{}:{}-{}", new Object[]{item.getLoggerName(), item.getCallerFilename(), item.getArg0(), item.getArg1(), item.getArg2()}));
            if (this.getSave2db().booleanValue()) {
                LoggingEvent.saveBatch(temp);
            }
            cacheMap.removeAll(temp);
            log.info(String.format("\u4fdd\u5b58\u5b8c\u6210\uff0c\u5f53\u524d\u5ba1\u8ba1\u96c6\u5408\u6570\u91cf\u4e3a[%s]", cacheMap.size()));
        }
    }

    private Boolean getSave2db() {
        if (this.save2db == null) {
            try {
                this.save2db = this.loggingEventMapper.checkLoggingEvent() == 0;
            }
            catch (Exception ex) {
                this.save2db = false;
            }
        }
        return this.save2db;
    }

    private LoggingEvent newAudit(HttpServletRequest request) {
        AuthenticationUser curUser = AuthenticationUser.getAuthenticationUser();
        LoggingEvent dataAudit = new LoggingEvent().setLevelString("TRACE").setTimeStamp(System.currentTimeMillis()).setReferenceFlag(1024).setArg1(curUser.getUserid()).setArg2(curUser.getDisplayName()).setArg3("1");
        if (request != null) {
            dataAudit.setThreadName(this.getIpAddress(request, curUser));
        }
        return dataAudit;
    }

    @Override
    public void createAudit(HttpServletRequest request, EntityBase entity, Object idValue) {
        BeanCache.BeanSchema schema = BeanCache.get(entity.getClass());
        if (ObjectUtils.isEmpty((Object)idValue)) {
            idValue = entity.get(schema.getKeyField().getCodeName());
        }
        LoggingEvent dataAudit = this.newAudit(request).setCallerFilename(schema.getCodeName()).setCallerClass(entity.getClass().getName()).setCallerMethod("create").setLoggerName(schema.getLogicName() + " \u65b0\u5efa").setArg0((String)idValue);
        this.getAuditInfo(entity, schema.getAudits()).forEach(item -> dataAudit.set(item.getId(), item));
        cacheMap.add(dataAudit);
    }

    @Override
    public void updateAudit(HttpServletRequest request, EntityBase beforeEntity, EntityBase afterEntity, Object idValue) {
        BeanCache.BeanSchema schema = BeanCache.get(beforeEntity.getClass());
        if (ObjectUtils.isEmpty((Object)idValue)) {
            idValue = beforeEntity.get(schema.getKeyField().getCodeName());
        }
        List<AuditItem> auditInfo = this.getUpdateAuditInfo(beforeEntity, afterEntity, schema.getAudits());
        LoggingEvent dataAudit = this.newAudit(request).setCallerFilename(schema.getCodeName()).setCallerClass(beforeEntity.getClass().getName()).setCallerMethod("update").setLoggerName(schema.getLogicName() + " \u66f4\u65b0").setArg0((String)idValue).setArg3(ObjectUtils.isEmpty(auditInfo) ? "0" : "1");
        auditInfo.forEach(item -> dataAudit.set(item.getId(), item));
        cacheMap.add(dataAudit);
    }

    @Override
    public void removeAudit(HttpServletRequest request, EntityBase entity, Object idValue) {
        BeanCache.BeanSchema schema = BeanCache.get(entity.getClass());
        if (ObjectUtils.isEmpty((Object)idValue)) {
            idValue = entity.get(schema.getKeyField().getCodeName());
        }
        LoggingEvent dataAudit = this.newAudit(request).setCallerFilename(schema.getCodeName()).setCallerClass(entity.getClass().getName()).setCallerMethod("remove").setLoggerName(schema.getLogicName() + " \u5220\u9664").setArg0((String)idValue);
        cacheMap.add(dataAudit);
    }

    @Override
    public void customAudit(String caller, String method, Object idValue, EntityBase entity, String name, HttpServletRequest request) {
        LoggingEvent dataAudit = this.newAudit(request).setCallerFilename(caller).setCallerClass(caller).setCallerMethod(method).setLoggerName(name).setArg0((String)idValue);
        if (entity != null) {
            BeanCache.BeanSchema schema = BeanCache.get(entity.getClass());
            if (ObjectUtils.isEmpty((Object)idValue)) {
                idValue = entity.get(schema.getKeyField().getCodeName());
            }
            dataAudit.setCallerClass(entity.getClass().getName()).setLoggerName(schema.getLogicName() + (ObjectUtils.isEmpty((Object)name) ? "" : " " + name)).setArg0((String)idValue);
            this.getAuditInfo(entity, schema.getAudits()).forEach(item -> dataAudit.set(item.getId(), item));
        }
        cacheMap.add(dataAudit);
    }
}

