/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.client.FeignRequestInterceptor;
import cn.ibizlab.util.command.ExecutionCommandContext;
import cn.ibizlab.util.command.ExecutionResult;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Request;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class RemoteService {
    @Autowired
    protected FeignContext feignContext;
    @Autowired
    private Client feignClient;
    @Autowired
    private FeignRequestInterceptor requestInterceptor;
    private static final Map<String, Object> FEIGN_CLIENTS = new ConcurrentHashMap<String, Object>();

    public RemoteFeignClient getClient(String serverId) {
        return this.create(RemoteFeignClient.class, serverId);
    }

    private synchronized <T> T create(Class<T> clazz, String serviceId) {
        Object object = FEIGN_CLIENTS.get(serviceId);
        if (Objects.isNull(object)) {
            Client client = this.feignClient;
            if (serviceId.startsWith("http") && this.feignClient instanceof FeignBlockingLoadBalancerClient) {
                client = ((FeignBlockingLoadBalancerClient)this.feignClient).getDelegate();
            }
            object = Feign.builder().decoder(this.feignDecoder()).encoder(this.feignEncoder()).client(client).options(new Request.Options(5000, 50000)).contract((Contract)this.feignContext.getInstance(serviceId, Contract.class)).requestInterceptor((RequestInterceptor)this.requestInterceptor).target(clazz, serviceId.startsWith("http") ? serviceId : "http://" + serviceId);
            FEIGN_CLIENTS.put(serviceId, object);
        }
        return (T)object;
    }

    private Decoder feignDecoder() {
        return new SpringDecoder(this.feignHttpMessageConverter());
    }

    private Encoder feignEncoder() {
        return new SpringEncoder(this.feignHttpMessageConverter());
    }

    private ObjectFactory<HttpMessageConverters> feignHttpMessageConverter() {
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter(new ObjectMapper());
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(new HttpMessageConverter[]{jsonConverter});
        return () -> httpMessageConverters;
    }

    public static interface RemoteFeignClient {
        @RequestMapping(method={RequestMethod.POST}, value={"/callback"})
        public ExecutionResult callback(@RequestHeader(value="Authorization") String var1, @RequestBody ExecutionCommandContext var2);

        @RequestMapping(method={RequestMethod.POST}, value={"/{path}"})
        public JSONArray postForList(@PathVariable(value="path") String var1, @RequestHeader(value="Authorization") String var2, @RequestBody Map var3);

        @RequestMapping(method={RequestMethod.POST}, value={"/{path}"})
        public JSONObject post(@PathVariable(value="path") String var1, @RequestHeader(value="Authorization") String var2, @RequestBody Map var3);

        @RequestMapping(method={RequestMethod.GET}, value={"/{path}"})
        public JSONObject request(@PathVariable(value="path") String var1, @RequestHeader(value="Authorization") String var2, Map var3);

        @RequestMapping(method={RequestMethod.GET}, value={"/{path}"})
        public JSONObject get(@PathVariable(value="path") String var1, @RequestHeader(value="Authorization") String var2);

        @RequestMapping(method={RequestMethod.PUT}, value={"/{path}"})
        public JSONObject put(@PathVariable(value="path") String var1, @RequestHeader(value="Authorization") String var2, @RequestBody Map var3);

        @RequestMapping(method={RequestMethod.DELETE}, value={"/{path}"})
        public JSONObject delete(@PathVariable(value="path") String var1, @RequestHeader(value="Authorization") String var2);
    }
}

