/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.domain.AuditItem;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.security.AuthenticationUser;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.ObjectUtils;

public interface IBZDataAuditService {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void createAudit(HttpServletRequest var1, EntityBase var2, Object var3);

    public void updateAudit(HttpServletRequest var1, EntityBase var2, EntityBase var3, Object var4);

    public void removeAudit(HttpServletRequest var1, EntityBase var2, Object var3);

    public void customAudit(String var1, String var2, Object var3, EntityBase var4, String var5, HttpServletRequest var6);

    default public List<AuditItem> getAuditInfo(EntityBase entity) {
        return this.getAuditInfo(entity, BeanCache.get(entity.getClass()).getAudits());
    }

    default public List<AuditItem> getAuditInfo(EntityBase entity, List<BeanCache.FieldItem> audits) {
        ArrayList<AuditItem> auditFieldArray = new ArrayList<AuditItem>();
        audits.forEach(item -> {
            String fieldName = item.getCodeName();
            DEField deField = item.getDeField();
            Object value = this.dataTransfer(entity.get(fieldName), item.getFormat());
            if (!ObjectUtils.isEmpty((Object)value)) {
                AuditItem auditFieldObj = new AuditItem();
                auditFieldObj.setId(item.getJsonName());
                auditFieldObj.setLabel(item.getLogicName());
                auditFieldObj.setValue(value);
                if (!ObjectUtils.isEmpty((Object)deField) && !ObjectUtils.isEmpty((Object)deField.dict())) {
                    auditFieldObj.setDict(deField.dict());
                }
                auditFieldArray.add(auditFieldObj);
            }
        });
        return auditFieldArray;
    }

    default public List<AuditItem> getUpdateAuditInfo(EntityBase oldData, EntityBase newData) {
        return this.getUpdateAuditInfo(oldData, newData, BeanCache.get(oldData.getClass()).getAudits());
    }

    default public List<AuditItem> getUpdateAuditInfo(EntityBase oldData, EntityBase newData, List<BeanCache.FieldItem> audits) {
        ArrayList<AuditItem> auditFieldArray = new ArrayList<AuditItem>();
        audits.forEach(item -> {
            Object newValue;
            String fieldName = item.getCodeName();
            DEField deField = item.getDeField();
            Object oldValue = oldData.get(fieldName);
            if (!this.compare(oldValue, newValue = newData.get(fieldName))) {
                AuditItem auditFieldObj = new AuditItem();
                auditFieldObj.setId(item.getJsonName());
                auditFieldObj.setLabel(item.getLogicName());
                auditFieldObj.setValue(this.dataTransfer(newValue, deField.format()));
                auditFieldObj.setBefore(this.dataTransfer(oldValue, deField.format()));
                if (!ObjectUtils.isEmpty((Object)deField) && !ObjectUtils.isEmpty((Object)deField.dict())) {
                    auditFieldObj.setDict(deField.dict());
                }
                auditFieldArray.add(auditFieldObj);
            }
        });
        return auditFieldArray;
    }

    default public Object dataTransfer(Object value, String strFormat) {
        if (value == null) {
            return "";
        }
        Object transResult = value;
        if (value instanceof Date) {
            Date timestamp = (Date)value;
            transResult = sdf.format(timestamp);
        } else if (!ObjectUtils.isEmpty((Object)strFormat)) {
            transResult = String.format(strFormat, transResult);
        }
        return transResult;
    }

    default public boolean compare(Object sourceObj, Object targetObj) {
        if (sourceObj == null && targetObj == null) {
            return true;
        }
        if (sourceObj == null && targetObj != null) {
            return false;
        }
        return sourceObj.equals(targetObj);
    }

    default public String getIpAddress(HttpServletRequest request, AuthenticationUser authenticationUser) {
        if (authenticationUser != null && !ObjectUtils.isEmpty((Object)authenticationUser.getClientIp())) {
            return authenticationUser.getClientIp();
        }
        if (request == null) {
            return "";
        }
        String Xip = request.getHeader("X-Real-IP");
        String XFor = request.getHeader("X-Forwarded-For");
        if (!ObjectUtils.isEmpty((Object)XFor) && !"unKnown".equalsIgnoreCase(XFor)) {
            int index = XFor.indexOf(",");
            if (index != -1) {
                return XFor.substring(0, index);
            }
            return XFor;
        }
        XFor = Xip;
        if (!ObjectUtils.isEmpty((Object)XFor) && !"unKnown".equalsIgnoreCase(XFor)) {
            return XFor;
        }
        if (ObjectUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("Proxy-Client-IP");
        }
        if (ObjectUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ObjectUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ObjectUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ObjectUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getRemoteAddr();
        }
        return XFor;
    }
}

