/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.domain.IEntity;
import cn.ibizlab.util.filter.ISearchContext;
import cn.ibizlab.util.filter.QueryFilter;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.security.AuthenticationUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.util.ObjectUtils;

public class AbstractPermissionEvaluator
implements PermissionEvaluator {
    @Value(value="${ibiz.enablePermissionValid:false}")
    boolean enablePermissionValid;

    public boolean isEnablePermissionValid() {
        return this.enablePermissionValid;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        return true;
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        if (!this.isEnablePermissionValid()) {
            return true;
        }
        Object principal = authentication.getPrincipal();
        if (ObjectUtils.isEmpty((Object)principal)) {
            return false;
        }
        AuthenticationUser authenticationUser = null;
        if (principal instanceof AuthenticationUser && (authenticationUser = (AuthenticationUser)authentication.getPrincipal()).isSuperUser()) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)authentication.getAuthorities())) {
            return false;
        }
        String[] pairs = String.valueOf(permission).split("-|:");
        String entityTag = pairs.length >= 2 ? pairs[1] : "";
        String action = pairs.length >= 3 ? pairs[2] : "";
        Set<String> userAuthorities = authentication.getAuthorities().stream().filter(item -> item.getAuthority().startsWith((String)permission)).map(item -> item.getAuthority()).collect(Collectors.toSet());
        if (userAuthorities.size() == 0) {
            return false;
        }
        if (userAuthorities.stream().filter(item -> item.endsWith(String.format("%s-all", action))).findAny().isPresent()) {
            return true;
        }
        if (targetDomainObject instanceof ArrayList && !((ArrayList)targetDomainObject).isEmpty() && ((ArrayList)targetDomainObject).get(0) instanceof IEntity) {
            for (IEntity entityBase : (List)targetDomainObject) {
                if (this.actionValid(entityBase, entityTag, action, (String)permission, userAuthorities, authenticationUser)) continue;
                return false;
            }
        } else if (targetDomainObject instanceof ISearchContext) {
            this.addFetchPermissionCondition((ISearchContext)targetDomainObject, entityTag, action, (String)permission, userAuthorities, authenticationUser);
        } else if (targetDomainObject instanceof IEntity) {
            return this.actionValid((IEntity)targetDomainObject, entityTag, action, (String)permission, userAuthorities, authenticationUser);
        }
        return true;
    }

    public BeanCache.BeanSchema getSchema(String entityTag) {
        return BeanCache.get(entityTag);
    }

    public void addFetchPermissionCondition(ISearchContext qc, String entityTag, String action, String permission, Set<String> userAuthorities, AuthenticationUser authenticationUser) {
        BeanCache.BeanSchema schema = this.getSchema(entityTag);
        if (schema == null) {
            schema = this.getSchema(qc.getClass().getSimpleName());
        }
        if (schema == null) {
            return;
        }
        String orgField = schema.getOrgField() != null ? schema.getOrgField().getFieldName() : null;
        String orgDeptField = schema.getOrgDeptField() != null ? schema.getOrgDeptField().getFieldName() : null;
        String orgTeamField = schema.getOrgTeamField() != null ? schema.getOrgTeamField().getFieldName() : null;
        String createManField = schema.getCreateManField() != null ? schema.getCreateManField().getFieldName() : null;
        HashSet userOrg = new HashSet();
        HashSet userOrgDept = new HashSet();
        HashSet userTeam = new HashSet();
        HashSet<String> userCreateMan = new HashSet<String>();
        for (String authority : userAuthorities) {
            if (authority.endsWith("curorg")) {
                userOrg.addAll(authenticationUser.getCurOrgIds());
                continue;
            }
            if (authority.endsWith("porg")) {
                userOrg.addAll(authenticationUser.getParentOrgIds());
                continue;
            }
            if (authority.endsWith("sorg")) {
                userOrg.addAll(authenticationUser.getCurOrgIds());
                userOrg.addAll(authenticationUser.getSubOrgIds());
                continue;
            }
            if (authority.endsWith("curorgdept")) {
                userOrgDept.addAll(authenticationUser.getCurDeptIds());
                continue;
            }
            if (authority.endsWith("porgdept")) {
                userOrgDept.addAll(authenticationUser.getParentDeptIds());
                continue;
            }
            if (authority.endsWith("sorgdept")) {
                userOrgDept.addAll(authenticationUser.getCurDeptIds());
                userOrgDept.addAll(authenticationUser.getSubDeptIds());
                continue;
            }
            if (authority.endsWith("curteam")) {
                userTeam.addAll(authenticationUser.getCurTeamIds());
                continue;
            }
            if (!authority.endsWith("createman")) continue;
            userCreateMan.add(authority);
        }
        qc.setFilter(QueryFilter.createQuery());
        if (userOrg.size() == 0 && userOrgDept.size() == 0 && userCreateMan.size() == 0) {
            qc.getFilter().custom("1<>1");
        } else {
            if (!ObjectUtils.isEmpty((Object)orgField) && userOrg.size() > 0) {
                qc.getFilter().or(QueryFilter.createQuery().in(orgField, userOrg));
            }
            if (!ObjectUtils.isEmpty((Object)orgDeptField) && userOrgDept.size() > 0) {
                qc.getFilter().or(QueryFilter.createQuery().in(orgDeptField, userOrgDept));
            }
            if (!ObjectUtils.isEmpty((Object)orgTeamField) && userTeam.size() > 0) {
                qc.getFilter().or(QueryFilter.createQuery().in(orgTeamField, userTeam));
            }
            if (!ObjectUtils.isEmpty((Object)createManField) && userCreateMan.size() > 0) {
                qc.getFilter().or(QueryFilter.createQuery().eq(createManField, authenticationUser.getUserid()));
            }
        }
    }

    public boolean actionValid(IEntity entity, String entityTag, String action, String permission, Set<String> userAuthorities, AuthenticationUser authenticationUser) {
        BeanCache.BeanSchema schema = this.getSchema(entityTag);
        if (schema == null) {
            schema = this.getSchema(entity.getClass().getSimpleName());
        }
        if (schema == null) {
            return false;
        }
        Object orgFieldValue = null;
        if (schema.getOrgField() != null) {
            orgFieldValue = entity.get(schema.getOrgField().getCodeName());
        }
        Object orgDeptFieldValue = null;
        if (schema.getOrgDeptField() != null) {
            orgDeptFieldValue = entity.get(schema.getOrgDeptField().getCodeName());
        }
        Object orgTeamFieldValue = null;
        if (schema.getOrgTeamField() != null) {
            orgTeamFieldValue = entity.get(schema.getOrgTeamField().getCodeName());
        }
        Object crateManFieldValue = null;
        if (schema.getCreateManField() != null) {
            crateManFieldValue = entity.get(schema.getCreateManField().getCodeName());
        }
        HashSet userOrg = new HashSet();
        HashSet userOrgDept = new HashSet();
        HashSet userTeam = new HashSet();
        for (String authority : userAuthorities) {
            if (authority.endsWith("curorg")) {
                userOrg.addAll(authenticationUser.getCurOrgIds());
                continue;
            }
            if (authority.endsWith("porg")) {
                userOrg.addAll(authenticationUser.getParentOrgIds());
                continue;
            }
            if (authority.endsWith("sorg")) {
                userOrg.addAll(authenticationUser.getCurOrgIds());
                userOrg.addAll(authenticationUser.getSubOrgIds());
                continue;
            }
            if (authority.endsWith("curorgdept")) {
                userOrgDept.addAll(authenticationUser.getCurDeptIds());
                continue;
            }
            if (authority.endsWith("porgdept")) {
                userOrgDept.addAll(authenticationUser.getParentDeptIds());
                continue;
            }
            if (authority.endsWith("sorgdept")) {
                userOrgDept.addAll(authenticationUser.getCurDeptIds());
                userOrgDept.addAll(authenticationUser.getSubDeptIds());
                continue;
            }
            if (!authority.endsWith("curteam")) continue;
            userTeam.addAll(authenticationUser.getCurTeamIds());
        }
        if (action.endsWith("Create") || action.endsWith("Save")) {
            if (!ObjectUtils.isEmpty((Object)orgFieldValue) && !userOrg.contains(orgFieldValue)) {
                return false;
            }
            if (!ObjectUtils.isEmpty((Object)orgDeptFieldValue) && !userOrgDept.contains(orgDeptFieldValue)) {
                return false;
            }
            if (!ObjectUtils.isEmpty((Object)orgTeamFieldValue) && !userTeam.contains(orgTeamFieldValue)) {
                return false;
            }
            return ObjectUtils.isEmpty((Object)crateManFieldValue) || authenticationUser.getUserid().equals(crateManFieldValue);
        }
        if (!ObjectUtils.isEmpty((Object)orgFieldValue) && userOrg.contains(orgFieldValue)) {
            return true;
        }
        if (!ObjectUtils.isEmpty((Object)orgDeptFieldValue) && userOrgDept.contains(orgDeptFieldValue)) {
            return true;
        }
        if (!ObjectUtils.isEmpty((Object)orgTeamFieldValue) && userTeam.contains(orgTeamFieldValue)) {
            return true;
        }
        return !ObjectUtils.isEmpty((Object)crateManFieldValue) && authenticationUser.getUserid().equals(crateManFieldValue);
    }
}

