/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.helper.typehandler;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import cn.ibizlab.util.security.SpringContextHolder;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.springframework.util.StringUtils;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={String.class})
public class EncryptTypeHandler
extends BaseTypeHandler<String> {
    public static String getEncryptStringKey() {
        return SpringContextHolder.getApplicationContext().getEnvironment().getProperty("ibiz.typehandler.encryptkey", "ibzkeys123456789");
    }

    public static byte[] getEncryptByteKey() {
        String keys = EncryptTypeHandler.getEncryptStringKey();
        return keys.getBytes(StandardCharsets.UTF_8);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        if (StringUtils.hasLength((String)parameter)) {
            AES aes = SecureUtil.aes((byte[])EncryptTypeHandler.getEncryptByteKey());
            String encrypt = aes.encryptHex(parameter);
            ps.setString(i, encrypt);
        } else {
            ps.setString(i, null);
        }
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.decrypt(rs.getString(columnName));
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.decrypt(rs.getString(columnIndex));
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.decrypt(cs.getString(columnIndex));
    }

    public String decrypt(String value) {
        if (StringUtils.hasLength((String)value)) {
            return SecureUtil.aes((byte[])EncryptTypeHandler.getEncryptByteKey()).decryptStr(value);
        }
        return null;
    }
}

