/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.helper;

import cn.hutool.core.convert.Convert;
import cn.ibizlab.util.domain.EntityBase;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.util.ObjectUtils;

public class RuleUtils {
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static Object getObj(Object object, String members) {
        if (object == null) {
            return null;
        }
        Object currentObj = object;
        for (String methodName : members.split("\\.")) {
            try {
                if (currentObj instanceof EntityBase) {
                    if ((currentObj = ((EntityBase)currentObj).get(methodName)) != null) continue;
                    return null;
                }
                if (currentObj instanceof Map) {
                    if ((currentObj = ((Map)currentObj).get(methodName)) != null) continue;
                    return null;
                }
                Class<?> clazz = currentObj.getClass();
                Method method = null;
                try {
                    method = clazz.getMethod("get", new Class[0]);
                }
                catch (Exception e2) {
                    method = clazz.getDeclaredMethod("get", new Class[0]);
                }
                currentObj = method.invoke(currentObj, methodName);
                if (currentObj != null) continue;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return currentObj;
    }

    public static boolean test(Object finalObject, String option, Object exp) {
        if (option.equalsIgnoreCase("eq") || option.equalsIgnoreCase("equal") || option.equalsIgnoreCase("=")) {
            return RuleUtils.equal(exp, finalObject);
        }
        if (option.equalsIgnoreCase("noteq") || option.equalsIgnoreCase("notequal") || option.equalsIgnoreCase("<>") || option.equalsIgnoreCase("!=")) {
            return !RuleUtils.equal(exp, finalObject);
        }
        if (option.equalsIgnoreCase("gt") || option.equalsIgnoreCase(">")) {
            return RuleUtils.gt(exp, finalObject);
        }
        if (option.equalsIgnoreCase("lt") || option.equalsIgnoreCase("<")) {
            return RuleUtils.lt(exp, finalObject);
        }
        if (option.equalsIgnoreCase("gtandeq") || option.equalsIgnoreCase("ge") || option.equalsIgnoreCase(">=")) {
            return RuleUtils.ge(exp, finalObject);
        }
        if (option.equalsIgnoreCase("ltandeq") || option.equalsIgnoreCase("le") || option.equalsIgnoreCase("<=")) {
            return RuleUtils.le(exp, finalObject);
        }
        if (option.equalsIgnoreCase("null") || option.equalsIgnoreCase("isnull")) {
            return RuleUtils.isNull(finalObject);
        }
        if (option.equalsIgnoreCase("notnull") || option.equalsIgnoreCase("isnotnull")) {
            return RuleUtils.isNotNull(finalObject);
        }
        if (option.equalsIgnoreCase("like") || option.equalsIgnoreCase("matchor")) {
            return RuleUtils.matchor(exp, finalObject);
        }
        if (option.equalsIgnoreCase("leftlike") || option.equalsIgnoreCase("startswith") || option.equalsIgnoreCase("begin")) {
            return RuleUtils.leftmatchor(exp, finalObject);
        }
        if (option.equalsIgnoreCase("rightlike") || option.equalsIgnoreCase("endswith") || option.equalsIgnoreCase("end")) {
            return RuleUtils.rightmatchor(exp, finalObject);
        }
        if (option.equalsIgnoreCase("match") || option.equalsIgnoreCase("matchand") || option.equalsIgnoreCase("matches")) {
            return RuleUtils.matchand(exp, finalObject);
        }
        if (option.equalsIgnoreCase("in")) {
            return RuleUtils.in(exp, finalObject);
        }
        if (option.equalsIgnoreCase("notin")) {
            return RuleUtils.notin(exp, finalObject);
        }
        if (option.equalsIgnoreCase("NOTLIKE")) {
            return RuleUtils.notmatchor(exp, finalObject);
        }
        if (option.equalsIgnoreCase("LEFTNOTLIKE")) {
            return !RuleUtils.leftmatchor(exp, finalObject);
        }
        if (option.equalsIgnoreCase("RIGHTNOTLIKE")) {
            return !RuleUtils.rightmatchor(exp, finalObject);
        }
        if (option.equalsIgnoreCase("NOTMATCHES")) {
            return RuleUtils.notmatchand(exp, finalObject);
        }
        return false;
    }

    public static boolean equal(Object exp, Object object, String members) {
        return RuleUtils.equal(exp, RuleUtils.getObj(object, members));
    }

    public static boolean equal(Object exp, Object finalObject) {
        if (exp == null) {
            return false;
        }
        if (finalObject == null) {
            return false;
        }
        if (exp instanceof String && ((String)exp).length() == 10 && finalObject instanceof Date) {
            return dateFormat.format(finalObject).equals(exp);
        }
        if (exp instanceof Date && finalObject instanceof Date) {
            return dateFormat.format(finalObject).equals(dateFormat.format(exp));
        }
        if (finalObject instanceof Date) {
            Date tm = Convert.toDate((Object)exp, null);
            if (tm == null) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)tm, (Object)finalObject);
        }
        if (ObjectUtils.nullSafeEquals((Object)exp, (Object)finalObject)) {
            return true;
        }
        return exp.toString().equalsIgnoreCase(finalObject.toString());
    }

    public static boolean gt(Object exp, Object object, String members) {
        return RuleUtils.gt(exp, RuleUtils.getObj(object, members));
    }

    public static boolean gt(Object exp, Object finalObject) {
        if (ObjectUtils.isEmpty((Object)exp)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)finalObject)) {
            return false;
        }
        try {
            if (finalObject instanceof Date) {
                Date finalTime = (Date)finalObject;
                Date tm = null;
                if (exp instanceof Date) {
                    tm = (Date)exp;
                } else {
                    tm = Convert.toDate((Object)exp, null);
                    if (tm == null) {
                        return false;
                    }
                }
                return finalTime.getTime() > tm.getTime();
            }
            if (finalObject instanceof Integer) {
                return (Integer)finalObject > Convert.toInt((Object)exp, (Integer)Integer.MAX_VALUE);
            }
            if (finalObject instanceof Double) {
                return (Double)finalObject > Convert.toDouble((Object)exp, (Double)Double.MAX_VALUE);
            }
            if (finalObject instanceof Float) {
                return ((Float)finalObject).floatValue() > Convert.toFloat((Object)exp, (Float)Float.valueOf(Float.MAX_VALUE)).floatValue();
            }
            if (finalObject instanceof BigDecimal) {
                return ((BigDecimal)finalObject).compareTo(Convert.toBigDecimal((Object)exp, (BigDecimal)BigDecimal.valueOf(Double.MAX_VALUE))) > 0;
            }
            if (finalObject instanceof BigInteger) {
                return ((BigInteger)finalObject).compareTo(Convert.toBigInteger((Object)exp, (BigInteger)BigInteger.valueOf(Long.MAX_VALUE))) > 0;
            }
            if (finalObject instanceof Long) {
                return (Long)finalObject > Convert.toLong((Object)exp, (Long)Long.MAX_VALUE);
            }
            if (finalObject instanceof String) {
                return finalObject.toString().compareToIgnoreCase(exp.toString()) > 0;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean lt(Object exp, Object object, String members) {
        return RuleUtils.lt(exp, RuleUtils.getObj(object, members));
    }

    public static boolean lt(Object exp, Object finalObject) {
        if (ObjectUtils.isEmpty((Object)exp)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)finalObject)) {
            return false;
        }
        try {
            if (finalObject instanceof Date) {
                Date finalTime = (Date)finalObject;
                Date tm = null;
                if (exp instanceof Date) {
                    tm = (Date)exp;
                } else {
                    tm = Convert.toDate((Object)exp, null);
                    if (tm == null) {
                        return false;
                    }
                }
                return finalTime.getTime() < tm.getTime();
            }
            if (finalObject instanceof Integer) {
                return (Integer)finalObject < Convert.toInt((Object)exp, (Integer)Integer.MIN_VALUE);
            }
            if (finalObject instanceof Double) {
                return (Double)finalObject < Convert.toDouble((Object)exp, (Double)Double.MIN_VALUE);
            }
            if (finalObject instanceof Float) {
                return ((Float)finalObject).floatValue() < Convert.toFloat((Object)exp, (Float)Float.valueOf(Float.MIN_VALUE)).floatValue();
            }
            if (finalObject instanceof BigDecimal) {
                return ((BigDecimal)finalObject).compareTo(Convert.toBigDecimal((Object)exp, (BigDecimal)BigDecimal.valueOf(Double.MIN_VALUE))) < 0;
            }
            if (finalObject instanceof BigInteger) {
                return ((BigInteger)finalObject).compareTo(Convert.toBigInteger((Object)exp, (BigInteger)BigInteger.valueOf(Long.MIN_VALUE))) < 0;
            }
            if (finalObject instanceof Long) {
                return (Long)finalObject < Convert.toLong((Object)exp, (Long)Long.MIN_VALUE);
            }
            if (finalObject instanceof String) {
                return finalObject.toString().compareToIgnoreCase(exp.toString()) < 0;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean ge(Object exp, Object object, String members) {
        return RuleUtils.ge(exp, RuleUtils.getObj(object, members));
    }

    public static boolean ge(Object exp, Object finalObject) {
        if (ObjectUtils.isEmpty((Object)exp)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)finalObject)) {
            return false;
        }
        return !RuleUtils.lt(exp, finalObject);
    }

    public static boolean le(Object exp, Object object, String members) {
        return RuleUtils.le(exp, RuleUtils.getObj(object, members));
    }

    public static boolean le(Object exp, Object finalObject) {
        if (ObjectUtils.isEmpty((Object)exp)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)finalObject)) {
            return false;
        }
        return !RuleUtils.gt(exp, finalObject);
    }

    public static boolean notin(Object expObj, Object object, String members) {
        return RuleUtils.notin(expObj, RuleUtils.getObj(object, members));
    }

    public static boolean notin(Object expObj, Object finalObject) {
        if (ObjectUtils.isEmpty((Object)finalObject)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)expObj)) {
            return false;
        }
        String tvs = expObj.toString().trim();
        if (ObjectUtils.isEmpty((Object)tvs)) {
            return false;
        }
        return !RuleUtils.in(expObj, finalObject);
    }

    public static boolean in(Object expObj, Object object, String members) {
        return RuleUtils.in(expObj, RuleUtils.getObj(object, members));
    }

    public static boolean in(Object expObj, Object finalObject) {
        if (ObjectUtils.isEmpty((Object)finalObject)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)expObj)) {
            return false;
        }
        String tvs = expObj.toString().trim();
        if (ObjectUtils.isEmpty((Object)tvs)) {
            return false;
        }
        if (finalObject instanceof Integer) {
            tvs = "i:" + tvs;
        } else if (finalObject instanceof String) {
            tvs = "s:" + tvs;
        }
        List<Object> acts = RuleUtils.parseTvs(tvs);
        for (Object act : acts) {
            if (!RuleUtils.equal(act, finalObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotNull(Object object, String members) {
        return RuleUtils.isNotNull(RuleUtils.getObj(object, members));
    }

    public static boolean isNotNull(Object finalObject) {
        return !RuleUtils.isNull(finalObject);
    }

    public static boolean isNull(Object object, String members) {
        return RuleUtils.isNull(RuleUtils.getObj(object, members));
    }

    public static boolean isNull(Object finalObject) {
        if (finalObject instanceof String) {
            return ObjectUtils.isEmpty((Object)finalObject.toString().trim());
        }
        return ObjectUtils.isEmpty((Object)finalObject);
    }

    public static boolean notmatchor(Object expObj, Object object, String members) {
        return RuleUtils.notmatchor(expObj, RuleUtils.getObj(object, members));
    }

    public static boolean notmatchor(Object expObj, Object obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)expObj)) {
            return false;
        }
        String exp = expObj.toString().trim();
        if (ObjectUtils.isEmpty((Object)exp)) {
            return false;
        }
        return !RuleUtils.matchor(expObj, obj);
    }

    public static boolean notmatchand(Object expObj, Object object, String members) {
        return RuleUtils.notmatchand(expObj, RuleUtils.getObj(object, members));
    }

    public static boolean notmatchand(Object expObj, Object finalObject) {
        if (ObjectUtils.isEmpty((Object)finalObject)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)expObj)) {
            return false;
        }
        String exp = expObj.toString().trim();
        if (ObjectUtils.isEmpty((Object)exp)) {
            return false;
        }
        return !RuleUtils.matchand(expObj, finalObject);
    }

    public static boolean matchor(Object expObj, Object object, String members) {
        return RuleUtils.matchor(expObj, RuleUtils.getObj(object, members));
    }

    public static boolean matchor(Object expObj, Object obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)expObj)) {
            return false;
        }
        String exp = expObj.toString().trim();
        if (ObjectUtils.isEmpty((Object)exp)) {
            return false;
        }
        exp = exp.replace(";", ",");
        exp = exp.replace("\uff1b", ",");
        exp = exp.replace("\uff0c", ",");
        String[] arr = exp.split(",");
        boolean bRt = false;
        for (String strExp : arr) {
            bRt = obj.toString().matches("(.*)" + strExp + "(.*)");
            if (!bRt) continue;
            return true;
        }
        return bRt;
    }

    public static boolean leftmatchor(Object expObj, Object obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)expObj)) {
            return false;
        }
        String exp = expObj.toString().trim();
        if (ObjectUtils.isEmpty((Object)exp)) {
            return false;
        }
        exp = exp.replace(";", ",");
        exp = exp.replace("\uff1b", ",");
        exp = exp.replace("\uff0c", ",");
        String[] arr = exp.split(",");
        boolean bRt = false;
        for (String strExp : arr) {
            bRt = obj.toString().matches(strExp + "(.*)");
            if (!bRt) continue;
            return true;
        }
        return bRt;
    }

    public static boolean rightmatchor(Object expObj, Object obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)expObj)) {
            return false;
        }
        String exp = expObj.toString().trim();
        if (ObjectUtils.isEmpty((Object)exp)) {
            return false;
        }
        exp = exp.replace(";", ",");
        exp = exp.replace("\uff1b", ",");
        exp = exp.replace("\uff0c", ",");
        String[] arr = exp.split(",");
        boolean bRt = false;
        for (String strExp : arr) {
            bRt = obj.toString().matches("(.*)" + strExp);
            if (!bRt) continue;
            return true;
        }
        return bRt;
    }

    public static boolean matchand(Object expObj, Object object, String members) {
        return RuleUtils.matchand(expObj, RuleUtils.getObj(object, members));
    }

    public static boolean matchand(Object expObj, Object obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)expObj)) {
            return false;
        }
        String exp = expObj.toString().trim();
        if (ObjectUtils.isEmpty((Object)exp)) {
            return false;
        }
        exp = exp.replace(";", ",");
        exp = exp.replace("\uff1b", ",");
        exp = exp.replace("\uff0c", ",");
        String[] arr = exp.split(",");
        String objstr = obj.toString();
        boolean bRt = true;
        for (String strExp : arr) {
            if (strExp.trim().length() == 0 || (bRt = obj.toString().matches("(.*)" + strExp + "(.*)"))) continue;
            return false;
        }
        return bRt;
    }

    private static List<Object> parseTvs(String tvs) {
        tvs = tvs.replace(";", ",");
        tvs = tvs.replace("\uff1b", ",");
        tvs = tvs.replace("\uff0c", ",");
        String type = "s";
        String values = "";
        String[] tv = tvs.split(":");
        if (tv.length > 1) {
            type = tv[0];
            values = tv[1];
        } else {
            values = tvs;
        }
        ArrayList<Object> acts = new ArrayList<Object>();
        switch (type) {
            case "i": {
                for (String value : values.split(",")) {
                    acts.add(new Integer(value.trim()));
                }
                break;
            }
            case "s": {
                for (String value : values.split(",")) {
                    acts.add(value.trim());
                }
                break;
            }
        }
        return acts;
    }

    public static boolean inc2s(String tvs, Object finalObject) {
        if (ObjectUtils.isEmpty((Object)finalObject)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)tvs)) {
            return false;
        }
        if (!(finalObject instanceof String)) {
            return false;
        }
        tvs = "s:" + tvs;
        List<Object> acts = RuleUtils.parseTvs(tvs);
        for (Object act : acts) {
            if (!RuleUtils.equal(RuleUtils.c2s(act.toString()), RuleUtils.c2s(finalObject.toString()))) continue;
            return true;
        }
        return false;
    }

    public static String c2s(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() < 300) {
            str = str.trim();
            str = str.replace("\uff11", "1").replace("\uff12", "2").replace("\uff13", "3").replace("\uff14", "4").replace("\uff15", "5").replace("\uff16", "6").replace("\uff17", "7").replace("\uff18", "8").replace("\uff19", "9").replace("\uff10", "0").replace("\uff08", "\u3014").replace("\uff09", "\u3015").replace("(", "\u3014").replace(")", "\u3015").replace("\u3010", "\u3014").replace("\u3011", "\u3015").replace("[", "\u3014").replace("]", "\u3015");
        }
        return str;
    }

    public static boolean notinc2s(String tvs, Object finalObject) {
        return !RuleUtils.inc2s(tvs, finalObject);
    }
}

