/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.helper;

import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.RequestWrapper;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.util.ArrayList;

public class RequestWrapperDeserializer<T extends DTOBase>
extends JsonDeserializer<RequestWrapper<T>>
implements ContextualDeserializer {
    private JavaType type;

    public RequestWrapperDeserializer() {
    }

    public RequestWrapperDeserializer(JavaType type) {
        this.type = type;
    }

    public RequestWrapper deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        RequestWrapper<Object> wrapper = new RequestWrapper<Object>();
        Class cls = this.type.getBindings().getBoundType(0).getRawClass();
        if (p.getCurrentToken() == JsonToken.START_ARRAY) {
            ArrayList<DTOBase> list = new ArrayList<DTOBase>();
            while (p.nextToken() != JsonToken.END_ARRAY) {
                DTOBase item = (DTOBase)ctxt.readValue(p, cls);
                list.add(item);
            }
            wrapper.setList(list);
        } else {
            DTOBase object = (DTOBase)ctxt.readValue(p, cls);
            wrapper.setDto(object);
        }
        return wrapper;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType type = ctxt.getContextualType() != null ? ctxt.getContextualType() : property.getMember().getType();
        return new RequestWrapperDeserializer<T>(type);
    }
}

