/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.helper;

import cn.hutool.core.util.ReflectUtil;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.StringAdvUtils;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.util.TypeUtils;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.util.ObjectUtils;

public class BeanCache {
    private static Map<String, BeanSchema> cache = new HashMap<String, BeanSchema>();
    private static Object objLock1 = new Object();
    private static Set<String> ignoFields = new HashSet<String>(Arrays.asList("handler", "_filter_signature", "serialVersionUID", "_methods_"));
    private static BeanSchema EMPTY = new BeanSchema();
    private static FieldItem EMPTY_FIELD = new FieldItem().setCodeName("").setFieldName("").setColumnName("").setJsonName("");

    private BeanCache() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> BeanSchema register(Class<T> clazz) {
        return BeanSchema.from(clazz);
    }

    public static <T> BeanSchema get(Class<T> clazz) {
        return BeanSchema.from(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanSchema get(String tag) {
        if (cache.containsKey(tag)) {
            return cache.get(tag);
        }
        Object object = objLock1;
        synchronized (object) {
            if (cache.containsKey(tag)) {
                return cache.get(tag);
            }
        }
        return EMPTY;
    }

    public static <T> boolean hasAudit(Class<T> clazz) {
        return BeanCache.get(clazz).isHasAudit();
    }

    public static <T> List<FieldItem> getFields(Class<T> clazz) {
        return BeanCache.get(clazz).getFields();
    }

    public static <T> FieldItem getField(Class<T> clazz, String fieldname) {
        return BeanSchema.from(clazz).get(fieldname);
    }

    public static <T> String getKeyField(Class<T> clazz) {
        BeanSchema schema = BeanSchema.from(clazz);
        if (schema.getKeyField() != null) {
            return schema.getKeyField().getCodeName();
        }
        return "";
    }

    public static <T> String getFieldRealName(Class<T> clazz, String fieldname) {
        FieldItem field = BeanCache.getField(clazz, fieldname);
        if (field != null) {
            return field.getCodeName();
        }
        return "";
    }

    public static <T> String getFieldName(Class<T> clazz, String fieldname) {
        FieldItem field = BeanCache.getField(clazz, fieldname);
        if (field != null) {
            return field.getFieldName();
        }
        return "";
    }

    public static <T> String getFieldColumnName(Class<T> clazz, String fieldname) {
        FieldItem field = BeanCache.getField(clazz, fieldname);
        if (field != null) {
            return field.getColumnName();
        }
        return "";
    }

    public static <T> Object fieldValueOf(Class<T> clazz, String fieldname, Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        Object resultValue = fieldValue;
        FieldItem item = BeanCache.getField(clazz, fieldname);
        if (item != null) {
            Class<?> type = item.getField().getType();
            resultValue = TypeUtils.cast((Object)fieldValue, type, null);
        }
        return resultValue;
    }

    public static class FieldItem {
        private String codeName;
        private String fieldName;
        private String columnName;
        private String jsonName;
        private String logicName;
        private String format;
        private java.lang.reflect.Field field;
        private Audit audit;
        private DEField deField;

        public String getCodeName() {
            if (this.codeName != null && this.codeName.length() > 1 && Character.isUpperCase(this.codeName.charAt(1))) {
                this.codeName = this.codeName.substring(0, 1).toUpperCase() + this.codeName.substring(1);
            }
            return this.codeName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getJsonName() {
            return this.jsonName;
        }

        public String getLogicName() {
            return this.logicName;
        }

        public String getFormat() {
            return this.format;
        }

        public java.lang.reflect.Field getField() {
            return this.field;
        }

        public Audit getAudit() {
            return this.audit;
        }

        public DEField getDeField() {
            return this.deField;
        }

        public FieldItem setCodeName(String codeName) {
            this.codeName = codeName;
            return this;
        }

        public FieldItem setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public FieldItem setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public FieldItem setJsonName(String jsonName) {
            this.jsonName = jsonName;
            return this;
        }

        public FieldItem setLogicName(String logicName) {
            this.logicName = logicName;
            return this;
        }

        public FieldItem setFormat(String format) {
            this.format = format;
            return this;
        }

        public FieldItem setField(java.lang.reflect.Field field) {
            this.field = field;
            return this;
        }

        public FieldItem setAudit(Audit audit) {
            this.audit = audit;
            return this;
        }

        public FieldItem setDeField(DEField deField) {
            this.deField = deField;
            return this;
        }

        public FieldItem() {
        }

        public FieldItem(String codeName, String fieldName, String columnName, String jsonName, String logicName, String format, java.lang.reflect.Field field, Audit audit, DEField deField) {
            this.codeName = codeName;
            this.fieldName = fieldName;
            this.columnName = columnName;
            this.jsonName = jsonName;
            this.logicName = logicName;
            this.format = format;
            this.field = field;
            this.audit = audit;
            this.deField = deField;
        }
    }

    public static class BeanSchema {
        private String codeName;
        private String name;
        private String pluralize;
        private String logicName;
        private FieldItem keyField;
        private boolean hasAudit = false;
        private FieldItem orgField;
        private FieldItem orgNameField;
        private FieldItem orgDeptField;
        private FieldItem orgDeptNameField;
        private FieldItem orgTeamField;
        private FieldItem createManField;
        private FieldItem createManNameField;
        private FieldItem updateManField;
        private FieldItem updateManNameField;
        private FieldItem createTimeField;
        private FieldItem updateTimeField;
        private FieldItem logicValidField;
        private Map<String, FieldItem> fieldMap = new LinkedHashMap<String, FieldItem>();
        private List<FieldItem> fields = new ArrayList<FieldItem>();
        private List<FieldItem> deFields = new ArrayList<FieldItem>();
        private List<FieldItem> audits = new ArrayList<FieldItem>();

        public boolean containsKey(String tag) {
            if (this.fieldMap.containsKey(tag)) {
                return true;
            }
            if (this.fieldMap.containsKey(tag.toLowerCase())) {
                return true;
            }
            return this.fieldMap.containsKey(tag.toLowerCase().replace("_", ""));
        }

        public FieldItem get(String tag) {
            if (this.fieldMap.containsKey(tag)) {
                return this.fieldMap.get(tag);
            }
            if (this.fieldMap.containsKey(tag.toLowerCase())) {
                return this.fieldMap.get(tag.toLowerCase());
            }
            if (this.fieldMap.containsKey(tag.toLowerCase().replace("_", ""))) {
                return this.fieldMap.get(tag.toLowerCase().replace("_", ""));
            }
            return null;
        }

        public FieldItem getField(String tag) {
            FieldItem item = this.get(tag);
            if (item == null) {
                return EMPTY_FIELD;
            }
            return item;
        }

        public String getFieldName(String tag, String defaultName) {
            FieldItem item = this.get(tag);
            if (item == null) {
                return defaultName;
            }
            return item.getFieldName();
        }

        public String translateFieldName(String tag) {
            return this.getFieldName(tag, tag);
        }

        public Audit getAudit(String tag) {
            FieldItem item = this.fieldMap.get(tag);
            if (item != null) {
                return item.getAudit();
            }
            return null;
        }

        public DEField getDEField(String tag) {
            FieldItem item = this.fieldMap.get(tag);
            if (item != null) {
                return item.getDeField();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> BeanSchema from(Class<T> clazz) {
            String className = clazz.getSimpleName();
            if (className.indexOf("_$") >= 0) {
                className = className.substring(0, className.lastIndexOf("_$"));
            }
            if (cache.containsKey(className)) {
                return (BeanSchema)cache.get(className);
            }
            Object object = objLock1;
            synchronized (object) {
                java.lang.reflect.Field[] fields;
                if (cache.containsKey(className)) {
                    return (BeanSchema)cache.get(className);
                }
                BeanSchema schema = new BeanSchema().setCodeName(className).setName(className).setPluralize(StringAdvUtils.pluralize((String)className));
                Map<String, FieldItem> result = schema.getFieldMap();
                List<FieldItem> list = schema.getFields();
                ApiModel apiModel = clazz.getAnnotation(ApiModel.class);
                if (!ObjectUtils.isEmpty((Object)apiModel)) {
                    if (!ObjectUtils.isEmpty((Object)apiModel.description())) {
                        schema.setLogicName(apiModel.description());
                        if (!ObjectUtils.isEmpty((Object)apiModel.value())) {
                            schema.setName(apiModel.value());
                        }
                    } else if (!ObjectUtils.isEmpty((Object)apiModel.value())) {
                        schema.setLogicName(apiModel.value());
                    }
                }
                if (clazz.getAnnotation(Audit.class) != null) {
                    schema.setHasAudit(true);
                }
                for (java.lang.reflect.Field field : fields = ReflectUtil.getFields(clazz)) {
                    TableId tableId;
                    TableField tableField;
                    Audit audit;
                    DEField deField;
                    Field mogoField;
                    ApiModelProperty apiModelProperty;
                    if (field.getAnnotation(Transient.class) != null || ignoFields.contains(field.getName())) continue;
                    FieldItem item = new FieldItem().setCodeName(field.getName()).setFieldName(field.getName()).setColumnName(field.getName().toLowerCase()).setJsonName(field.getName().toLowerCase()).setLogicName(field.getName()).setField(field);
                    JSONField jsField = field.getAnnotation(JSONField.class);
                    if (!ObjectUtils.isEmpty((Object)jsField)) {
                        if (!ObjectUtils.isEmpty((Object)jsField.name())) {
                            item.setJsonName(jsField.name());
                        }
                        if (!ObjectUtils.isEmpty((Object)jsField.format())) {
                            item.setFormat(jsField.format());
                        }
                    } else {
                        JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
                        if (!ObjectUtils.isEmpty((Object)jsonProperty) && !ObjectUtils.isEmpty((Object)jsonProperty.value())) {
                            item.setJsonName(jsonProperty.value());
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)(apiModelProperty = field.getAnnotation(ApiModelProperty.class)))) {
                        if (!ObjectUtils.isEmpty((Object)apiModelProperty.notes())) {
                            item.setLogicName(apiModelProperty.notes());
                            if (!ObjectUtils.isEmpty((Object)apiModelProperty.value())) {
                                item.setFieldName(apiModelProperty.value()).setColumnName(apiModelProperty.value());
                            }
                        } else if (!ObjectUtils.isEmpty((Object)apiModelProperty.value())) {
                            item.setLogicName(apiModelProperty.value());
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)(mogoField = field.getAnnotation(Field.class))) && !ObjectUtils.isEmpty((Object)mogoField.name())) {
                        item.setFieldName(mogoField.name()).setColumnName(mogoField.name());
                    }
                    if (!ObjectUtils.isEmpty((Object)(deField = field.getAnnotation(DEField.class)))) {
                        if (!ObjectUtils.isEmpty((Object)deField.name())) {
                            item.setFieldName(deField.name()).setColumnName(deField.name());
                        }
                        item.setDeField(deField);
                        schema.getDeFields().add(item);
                        if (deField.isKeyField()) {
                            schema.setKeyField(item);
                        }
                        switch (deField.preType()) {
                            case CREATEMAN: {
                                schema.setCreateManField(item);
                                break;
                            }
                            case CREATEMANNAME: {
                                schema.setCreateManNameField(item);
                                break;
                            }
                            case UPDATEMAN: {
                                schema.setUpdateManField(item);
                                break;
                            }
                            case UPDATEMANNAME: {
                                schema.setUpdateManNameField(item);
                                break;
                            }
                            case CREATEDATE: {
                                schema.setCreateTimeField(item);
                                break;
                            }
                            case UPDATEDATE: {
                                schema.setUpdateTimeField(item);
                                break;
                            }
                            case ORGID: {
                                schema.setOrgField(item);
                                break;
                            }
                            case ORGNAME: {
                                schema.setOrgNameField(item);
                                break;
                            }
                            case ORGSECTORID: {
                                schema.setOrgDeptField(item);
                                break;
                            }
                            case ORGSECTORNAME: {
                                schema.setOrgDeptNameField(item);
                                break;
                            }
                            case LOGICVALID: {
                                schema.setLogicValidField(item);
                                break;
                            }
                        }
                        if (deField.defaultValueType().equals((Object)DEFieldDefaultValueType.SESSION) && deField.defaultValue().toLowerCase().indexOf("teamid") >= 0) {
                            schema.setOrgTeamField(item);
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)(audit = field.getAnnotation(Audit.class)))) {
                        item.setAudit(audit);
                        schema.getAudits().add(item);
                        schema.setHasAudit(true);
                    }
                    if (!ObjectUtils.isEmpty((Object)(tableField = field.getAnnotation(TableField.class)))) {
                        if (tableField.exist() && ObjectUtils.isEmpty((Object)tableField.value())) {
                            item.setFieldName(tableField.value()).setColumnName(tableField.value());
                        } else if (!tableField.exist()) {
                            item.setColumnName("");
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)(tableId = field.getAnnotation(TableId.class)))) {
                        if (!ObjectUtils.isEmpty((Object)tableId.value())) {
                            item.setFieldName(tableId.value()).setColumnName(tableId.value());
                        }
                        schema.setKeyField(item);
                    }
                    if (schema.getKeyField() == null && !ObjectUtils.isEmpty((Object)field.getAnnotation(Id.class))) {
                        schema.setKeyField(item);
                    }
                    list.add(item);
                    result.put(item.getCodeName(), item);
                    result.put(item.getCodeName().toLowerCase(), item);
                    result.put(item.getFieldName(), item);
                    result.put(item.getFieldName().toLowerCase(), item);
                    result.put(item.getJsonName(), item);
                    result.put(item.getJsonName().toLowerCase(), item);
                    if (ObjectUtils.isEmpty((Object)item.getColumnName())) continue;
                    result.put(item.getColumnName(), item);
                    result.put(item.getColumnName().toLowerCase(), item);
                }
                cache.put(schema.getCodeName(), schema);
                cache.put(schema.getName(), schema);
                cache.put(schema.getCodeName().toLowerCase(), schema);
                cache.put(schema.getName().toLowerCase(), schema);
                cache.put(schema.getCodeName().toLowerCase(), schema);
                cache.put(schema.getPluralize(), schema);
                return schema;
            }
        }

        public String getCodeName() {
            return this.codeName;
        }

        public String getName() {
            return this.name;
        }

        public String getPluralize() {
            return this.pluralize;
        }

        public String getLogicName() {
            return this.logicName;
        }

        public FieldItem getKeyField() {
            return this.keyField;
        }

        public boolean isHasAudit() {
            return this.hasAudit;
        }

        public FieldItem getOrgField() {
            return this.orgField;
        }

        public FieldItem getOrgNameField() {
            return this.orgNameField;
        }

        public FieldItem getOrgDeptField() {
            return this.orgDeptField;
        }

        public FieldItem getOrgDeptNameField() {
            return this.orgDeptNameField;
        }

        public FieldItem getOrgTeamField() {
            return this.orgTeamField;
        }

        public FieldItem getCreateManField() {
            return this.createManField;
        }

        public FieldItem getCreateManNameField() {
            return this.createManNameField;
        }

        public FieldItem getUpdateManField() {
            return this.updateManField;
        }

        public FieldItem getUpdateManNameField() {
            return this.updateManNameField;
        }

        public FieldItem getCreateTimeField() {
            return this.createTimeField;
        }

        public FieldItem getUpdateTimeField() {
            return this.updateTimeField;
        }

        public FieldItem getLogicValidField() {
            return this.logicValidField;
        }

        public Map<String, FieldItem> getFieldMap() {
            return this.fieldMap;
        }

        public List<FieldItem> getFields() {
            return this.fields;
        }

        public List<FieldItem> getDeFields() {
            return this.deFields;
        }

        public List<FieldItem> getAudits() {
            return this.audits;
        }

        public BeanSchema setCodeName(String codeName) {
            this.codeName = codeName;
            return this;
        }

        public BeanSchema setName(String name) {
            this.name = name;
            return this;
        }

        public BeanSchema setPluralize(String pluralize) {
            this.pluralize = pluralize;
            return this;
        }

        public BeanSchema setLogicName(String logicName) {
            this.logicName = logicName;
            return this;
        }

        public BeanSchema setKeyField(FieldItem keyField) {
            this.keyField = keyField;
            return this;
        }

        public BeanSchema setHasAudit(boolean hasAudit) {
            this.hasAudit = hasAudit;
            return this;
        }

        public BeanSchema setOrgField(FieldItem orgField) {
            this.orgField = orgField;
            return this;
        }

        public BeanSchema setOrgNameField(FieldItem orgNameField) {
            this.orgNameField = orgNameField;
            return this;
        }

        public BeanSchema setOrgDeptField(FieldItem orgDeptField) {
            this.orgDeptField = orgDeptField;
            return this;
        }

        public BeanSchema setOrgDeptNameField(FieldItem orgDeptNameField) {
            this.orgDeptNameField = orgDeptNameField;
            return this;
        }

        public BeanSchema setOrgTeamField(FieldItem orgTeamField) {
            this.orgTeamField = orgTeamField;
            return this;
        }

        public BeanSchema setCreateManField(FieldItem createManField) {
            this.createManField = createManField;
            return this;
        }

        public BeanSchema setCreateManNameField(FieldItem createManNameField) {
            this.createManNameField = createManNameField;
            return this;
        }

        public BeanSchema setUpdateManField(FieldItem updateManField) {
            this.updateManField = updateManField;
            return this;
        }

        public BeanSchema setUpdateManNameField(FieldItem updateManNameField) {
            this.updateManNameField = updateManNameField;
            return this;
        }

        public BeanSchema setCreateTimeField(FieldItem createTimeField) {
            this.createTimeField = createTimeField;
            return this;
        }

        public BeanSchema setUpdateTimeField(FieldItem updateTimeField) {
            this.updateTimeField = updateTimeField;
            return this;
        }

        public BeanSchema setLogicValidField(FieldItem logicValidField) {
            this.logicValidField = logicValidField;
            return this;
        }

        public BeanSchema setFieldMap(Map<String, FieldItem> fieldMap) {
            this.fieldMap = fieldMap;
            return this;
        }

        public BeanSchema setFields(List<FieldItem> fields) {
            this.fields = fields;
            return this;
        }

        public BeanSchema setDeFields(List<FieldItem> deFields) {
            this.deFields = deFields;
            return this;
        }

        public BeanSchema setAudits(List<FieldItem> audits) {
            this.audits = audits;
            return this;
        }

        public BeanSchema() {
        }

        public BeanSchema(String codeName, String name, String pluralize, String logicName, FieldItem keyField, boolean hasAudit, FieldItem orgField, FieldItem orgNameField, FieldItem orgDeptField, FieldItem orgDeptNameField, FieldItem orgTeamField, FieldItem createManField, FieldItem createManNameField, FieldItem updateManField, FieldItem updateManNameField, FieldItem createTimeField, FieldItem updateTimeField, FieldItem logicValidField, Map<String, FieldItem> fieldMap, List<FieldItem> fields, List<FieldItem> deFields, List<FieldItem> audits) {
            this.codeName = codeName;
            this.name = name;
            this.pluralize = pluralize;
            this.logicName = logicName;
            this.keyField = keyField;
            this.hasAudit = hasAudit;
            this.orgField = orgField;
            this.orgNameField = orgNameField;
            this.orgDeptField = orgDeptField;
            this.orgDeptNameField = orgDeptNameField;
            this.orgTeamField = orgTeamField;
            this.createManField = createManField;
            this.createManNameField = createManNameField;
            this.updateManField = updateManField;
            this.updateManNameField = updateManNameField;
            this.createTimeField = createTimeField;
            this.updateTimeField = updateTimeField;
            this.logicValidField = logicValidField;
            this.fieldMap = fieldMap;
            this.fields = fields;
            this.deFields = deFields;
            this.audits = audits;
        }
    }
}

